/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import com.floragunn.searchguard.lpg.Streams;
import java.io.IOException;
import java.security.SecureRandom;

public class PaddingPacket
extends ContainedPacket {
    private final byte[] padding;

    public PaddingPacket(BCPGInputStream in) throws IOException {
        this(in, true);
    }

    public PaddingPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(21, newPacketFormat);
        this.padding = Streams.readAll(in);
    }

    public PaddingPacket(byte[] padding) {
        super(21, true);
        this.padding = padding;
    }

    public PaddingPacket(int octetLen, SecureRandom random) {
        this(PaddingPacket.randomBytes(octetLen, random));
    }

    private static byte[] randomBytes(int octetCount, SecureRandom random) {
        if (octetCount <= 0) {
            throw new IllegalArgumentException("Octet count MUST NOT be 0 nor negative.");
        }
        byte[] bytes = new byte[octetCount];
        random.nextBytes(bytes);
        return bytes;
    }

    public byte[] getPadding() {
        return Arrays.clone(this.padding);
    }

    @Override
    public void encode(BCPGOutputStream pOut) throws IOException {
        pOut.writePacket(this.hasNewPacketFormat(), 21, this.padding);
    }
}

