/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGKey;
import com.floragunn.searchguard.lpg.BCPGObject;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import com.floragunn.searchguard.lpg.Pack;
import com.floragunn.searchguard.lpg.PublicKeyAlgorithmTags;
import com.floragunn.searchguard.lpg.RSAPublicBCPGKey;
import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.UnknownBCPGKey;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int LIBREPGP_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    PublicKeyPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        this(6, in, newPacketFormat);
    }

    PublicKeyPacket(int keyTag, BCPGInputStream in) throws IOException {
        this(keyTag, in, false);
    }

    PublicKeyPacket(int keyTag, BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(keyTag, newPacketFormat);
        this.version = in.read();
        if (this.version < 2 || this.version > 6) {
            throw new UnsupportedPacketVersionException("Unsupported Public Key Packet version encountered: " + this.version);
        }
        this.time = (long)StreamUtil.read4OctetLength(in) & 0xFFFFFFFFL;
        if (this.version == 2 || this.version == 3) {
            this.validDays = StreamUtil.read2OctetLength(in);
        }
        this.algorithm = (byte)in.read();
        long keyOctets = -1L;
        if (this.version == 5 || this.version == 6) {
            keyOctets = StreamUtil.read4OctetLength(in);
        }
        this.parseKey(in, this.algorithm, keyOctets);
    }

    private void parseKey(BCPGInputStream in, int algorithmId, long optLen) throws IOException {
        switch (algorithmId) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(in);
                break;
            }
            default: {
                if (this.version == 6 || this.version == 5) {
                    this.key = new UnknownBCPGKey((int)optLen, in);
                    break;
                }
                throw new IOException("unknown PGP public key algorithm encountered: " + this.algorithm);
            }
        }
    }

    @Deprecated
    public PublicKeyPacket(int algorithm, Date time, BCPGKey key) {
        this(4, algorithm, time, key);
    }

    public PublicKeyPacket(int version, int algorithm, Date time, BCPGKey key) {
        this(6, version, algorithm, time, key);
    }

    PublicKeyPacket(int keyTag, int version, int algorithm, Date time, BCPGKey key) {
        super(keyTag);
        this.version = version;
        this.time = time.getTime() / 1000L;
        this.algorithm = algorithm;
        this.key = key;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        StreamUtil.writeSeconds(pOut, this.time);
        if (this.version <= 3) {
            StreamUtil.write2OctetLength(pOut, this.validDays);
        }
        pOut.write(this.algorithm);
        if (this.version == 6 || this.version == 5) {
            StreamUtil.write4OctetLength(pOut, this.key.getEncoded().length);
        }
        pOut.writeObject((BCPGObject)((Object)this.key));
        pOut.close();
        return bOut.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.hasNewPacketFormat(), this.getPacketTag(), this.getEncodedContents());
    }

    public static long getKeyID(PublicKeyPacket publicPk, byte[] fingerprint) {
        if (publicPk.version <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)publicPk.key;
            return rK.getModulus().longValue();
        }
        if (publicPk.version == 4) {
            return Pack.bigEndianToLong(fingerprint, fingerprint.length - 8);
        }
        if (publicPk.version == 5 || publicPk.version == 6) {
            return Pack.bigEndianToLong(fingerprint, 0);
        }
        return 0L;
    }
}

