/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open.operator.bc;

import com.floragunn.searchguard.lpg.BCPGKey;
import com.floragunn.searchguard.lpg.GeneralDigest;
import com.floragunn.searchguard.lpg.PublicKeyPacket;
import com.floragunn.searchguard.lpg.SHA1Digest;
import com.floragunn.searchguard.lpg.SHA256Digest;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import com.floragunn.searchguard.lpg.open.PGPException;
import com.floragunn.searchguard.lpg.open.operator.KeyFingerPrintCalculator;
import java.io.IOException;

public class BcKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    @Override
    public byte[] calculateFingerprint(PublicKeyPacket publicPk) throws PGPException {
        GeneralDigest digest;
        byte[] kBytes;
        BCPGKey key = publicPk.getKey();
        if (publicPk.getVersion() == 4) {
            try {
                kBytes = publicPk.getEncodedContents();
                digest = new SHA1Digest();
                digest.update((byte)-103);
                digest.update((byte)(kBytes.length >> 8));
                digest.update((byte)kBytes.length);
                digest.update(kBytes, 0, kBytes.length);
            }
            catch (IOException e) {
                throw new PGPException("can't encode key components: " + e.getMessage(), e);
            }
        } else if (publicPk.getVersion() == 5 || publicPk.getVersion() == 6) {
            try {
                kBytes = publicPk.getEncodedContents();
                digest = new SHA256Digest();
                digest.update((byte)(publicPk.getVersion() == 6 ? 155 : 154));
                digest.update((byte)(kBytes.length >> 24));
                digest.update((byte)(kBytes.length >> 16));
                digest.update((byte)(kBytes.length >> 8));
                digest.update((byte)kBytes.length);
                digest.update(kBytes, 0, kBytes.length);
            }
            catch (IOException e) {
                throw new PGPException("can't encode key components: " + e.getMessage(), e);
            }
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP key version: " + publicPk.getVersion());
        }
        byte[] digBuf = new byte[digest.getDigestSize()];
        digest.doFinal(digBuf, 0);
        return digBuf;
    }
}

