/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule;

import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleFactory;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleImpl;
import com.floragunn.searchsupport.jobs.config.schedule.elements.TriggerFactory;
import java.text.ParseException;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.codec.digest.DigestUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class DefaultScheduleFactory
implements ScheduleFactory<ScheduleImpl> {
    public static DefaultScheduleFactory INSTANCE = new DefaultScheduleFactory();
    protected String group = "main";

    @Override
    public ScheduleImpl create(JobKey jobKey, DocNode objectNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(objectNode, validationErrors);
        ArrayList<Trigger> result = new ArrayList<Trigger>();
        if (vJsonNode.hasNonNull("schedule")) {
            try {
                result.addAll(this.createScheduleTriggers(jobKey, vJsonNode.get("schedule").asDocNode()));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("schedule", e);
            }
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new ScheduleImpl(result);
    }

    protected List<Trigger> createScheduleTriggers(JobKey jobKey, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        ZoneId timeZoneId = vJsonNode.get("timezone").asTimeZoneId();
        TimeZone timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
        MisfireStrategy misfireStrategy = (MisfireStrategy)vJsonNode.get("when_late").withDefault((Enum)MisfireStrategy.EXECUTE_NOW).asEnum(MisfireStrategy.class);
        triggers.addAll((Collection<Trigger>)vJsonNode.get("cron").asList().withEmptyListAsDefault().ofObjectsParsedByString(s -> this.createCronTrigger(jobKey, (String)s, timeZone, misfireStrategy)));
        triggers.addAll((Collection<Trigger>)vJsonNode.get("interval").asList().withEmptyListAsDefault().ofObjectsParsedByString(s -> this.createIntervalScheduleTrigger(jobKey, (String)s, misfireStrategy)));
        for (TriggerFactory<?> scheduleFactory : TriggerFactory.FACTORIES) {
            triggers.addAll((Collection<Trigger>)vJsonNode.get(scheduleFactory.getType()).asList().withEmptyListAsDefault().ofObjectsParsedBy(n -> this.createTrigger(jobKey, (DocNode)n, timeZone, scheduleFactory, misfireStrategy)));
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return triggers;
    }

    protected String getTriggerKey(String trigger) {
        return DigestUtils.md5Hex((String)trigger);
    }

    protected Trigger createCronTrigger(JobKey jobKey, String cronExpression, TimeZone timeZone, MisfireStrategy misfireStrategy) throws ConfigValidationException {
        String triggerKey = this.getTriggerKey(cronExpression);
        try {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)cronExpression).inTimeZone(timeZone);
            scheduleBuilder = misfireStrategy == MisfireStrategy.EXECUTE_NOW ? scheduleBuilder.withMisfireHandlingInstructionFireAndProceed() : scheduleBuilder.withMisfireHandlingInstructionDoNothing();
            return TriggerBuilder.newTrigger().withIdentity(jobKey.getName() + "___" + triggerKey, this.group).forJob(jobKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        }
        catch (ParseException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)cronExpression, (Object)"Quartz Cron Expression: <Seconds: 0-59|*> <Minutes: 0-59|*> <Hours: 0-23|*> <Day-of-Month: 1-31|?|*> <Month: JAN-DEC|*> <Day-of-Week: SUN-SAT|?|*> <Year: 1970-2199|*>?. Numeric ranges: 1-2; Several distinct values: 1,2; Increments: 0/15").message("Invalid cron expression: " + e.getMessage()).cause((Throwable)e));
        }
    }

    protected Trigger createIntervalScheduleTrigger(JobKey jobKey, String interval, MisfireStrategy misfireStrategy) throws ConfigValidationException {
        String triggerKey = this.getTriggerKey(interval);
        Duration duration = DurationFormat.INSTANCE.parse(interval);
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().repeatForever().withMisfireHandlingInstructionFireNow().withIntervalInMilliseconds(duration.toMillis());
        scheduleBuilder = misfireStrategy == MisfireStrategy.EXECUTE_NOW ? scheduleBuilder.withMisfireHandlingInstructionFireNow() : scheduleBuilder.withMisfireHandlingInstructionNextWithExistingCount();
        return TriggerBuilder.newTrigger().withIdentity(jobKey.getName() + "___" + triggerKey, this.group).forJob(jobKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }

    protected Trigger createTrigger(JobKey jobKey, DocNode jsonNode, TimeZone timeZone, TriggerFactory<?> scheduleFactory, MisfireStrategy misfireStrategy) throws ConfigValidationException {
        String triggerKey = this.getTriggerKey(jsonNode.toString());
        Object trigger = scheduleFactory.create(jsonNode, timeZone, misfireStrategy);
        trigger.setJobKey(jobKey);
        trigger.setKey(new TriggerKey(jobKey.getName() + "___" + triggerKey, this.group));
        return trigger;
    }

    public static enum MisfireStrategy {
        EXECUTE_NOW,
        SKIP;

    }
}

