/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.client.SearchScroller;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

class StepRepository {
    private static final Logger log = LogManager.getLogger(StepRepository.class);
    public static final int BATCH_SIZE = 100;
    private final PrivilegedConfigClient client;

    StepRepository(PrivilegedConfigClient client) {
        this.client = Objects.requireNonNull(client, "Client is required");
    }

    public IndicesStatsResponse findIndexState(String ... indexNames) {
        Objects.requireNonNull(indexNames, "Indices are required");
        IndicesStatsResponse response = (IndicesStatsResponse)this.client.admin().indices().stats((IndicesStatsRequest)new IndicesStatsRequest().indices(indexNames)).actionGet();
        if (response.getFailedShards() > 0) {
            throw new StepException("Cannot load current indices state", StepExecutionStatus.CANNOT_RETRIEVE_INDICES_STATE_ERROR, null);
        }
        if (this.isFailure(response.getStatus())) {
            throw new StepException("Unsuccessful index state response", StepExecutionStatus.CANNOT_RETRIEVE_INDICES_STATE_ERROR, null);
        }
        return response;
    }

    public Optional<GetIndexResponse> findIndexByNameOrAlias(String indexNameOrAlias) {
        Strings.requireNonEmpty((String)indexNameOrAlias, (String)"Index or alias name is required");
        try {
            GetIndexRequest request = new GetIndexRequest(Constants.DEFAULT_MASTER_TIMEOUT);
            request.indices(new String[]{indexNameOrAlias});
            GetIndexResponse response = (GetIndexResponse)this.client.admin().indices().getIndex(request).actionGet();
            return Optional.ofNullable(response);
        }
        catch (IndexNotFoundException e) {
            return Optional.empty();
        }
    }

    public GetIndexResponse findAllIndicesIncludingHidden() {
        GetIndexRequest request = new GetIndexRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{"*"}).indicesOptions(IndicesOptions.strictExpandHidden());
        return (GetIndexResponse)this.client.admin().indices().getIndex(request).actionGet();
    }

    public GetSettingsResponse getIndexSettings(String ... indices) {
        Objects.requireNonNull(indices, "Indices are required");
        GetSettingsRequest request = new GetSettingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(indices);
        return (GetSettingsResponse)this.client.admin().indices().getSettings(request).actionGet();
    }

    public void writeBlockIndices(ImmutableList<String> indices) {
        Objects.requireNonNull(indices, "Indices list is required");
        AddIndexBlockResponse response = (AddIndexBlockResponse)this.client.admin().indices().prepareAddBlock(IndexMetadata.APIBlock.WRITE, (String[])indices.toArray(String[]::new)).get();
        if (!response.isAcknowledged()) {
            String details = "Indices to block " + indices.stream().map(name -> "'" + name + "'").collect(Collectors.joining(", "));
            throw new StepException("Cannot block indices", StepExecutionStatus.WRITE_BLOCK_ERROR, details);
        }
    }

    public void releaseWriteLock(ImmutableList<String> indices) {
        Objects.requireNonNull(indices, "Indices list is required");
        Settings settings = Settings.builder().put(IndexMetadata.APIBlock.WRITE.settingName(), false).build();
        UpdateSettingsRequest request = new UpdateSettingsRequest((String[])indices.toArray(String[]::new)).settings(settings);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)this.client.admin().indices().updateSettings(request).actionGet();
        if (!acknowledgedResponse.isAcknowledged()) {
            String details = "Indices to unblock " + indices.stream().map(name -> "'" + name + "'").collect(Collectors.joining(", "));
            throw new StepException("Cannot unblock indices", StepExecutionStatus.WRITE_UNBLOCK_ERROR, details);
        }
    }

    public GetMappingsResponse findIndexMappings(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        return (GetMappingsResponse)this.client.admin().indices().getMappings(new GetMappingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{indexName})).actionGet();
    }

    public void createIndex(String name, int numberOfShards, int numberOfReplicas, long mappingsTotalFieldsLimit, Map<String, Object> mappingSources) {
        Strings.requireNonEmpty((String)name, (String)"Index name is required");
        Objects.requireNonNull(mappingSources, "Mappings for index creation are required");
        Settings settings = Settings.builder().put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", numberOfReplicas).put(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), mappingsTotalFieldsLimit).build();
        CreateIndexRequest request = new CreateIndexRequest().index(name).settings(settings).mapping(mappingSources);
        CreateIndexResponse response = (CreateIndexResponse)this.client.admin().indices().create(request).actionGet();
        if (!response.isAcknowledged()) {
            throw new StepException("Cannot create index " + name, StepExecutionStatus.CANNOT_CREATE_INDEX_ERROR, null);
        }
    }

    public void forEachDocumentInIndex(String indexName, int batchSize, Consumer<ImmutableList<SearchHit>> consumer) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required.");
        Objects.requireNonNull(consumer, "Search hits consumer is required.");
        SearchScroller searchScroller = new SearchScroller((Client)this.client);
        SearchRequest request = new SearchRequest(new String[]{indexName});
        request.source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(batchSize));
        searchScroller.scroll(request, TimeValue.timeValueMinutes((long)5L), Function.identity(), consumer);
    }

    public void bulkCreate(String indexName, Map<String, String> documents) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        Objects.requireNonNull(documents, "Documents to create are required.");
        String sortedDocumentsIds = documents.keySet().stream().sorted().map(id -> "'" + id + "'").collect(Collectors.joining(", "));
        log.info("Index '{}', bulk create documents {}", (Object)indexName, (Object)sortedDocumentsIds);
        BulkRequest bulkRequest = new BulkRequest(indexName);
        for (Map.Entry<String, String> currentDocument : documents.entrySet()) {
            IndexRequest indexRequest = new IndexRequest(indexName);
            indexRequest.create(true);
            indexRequest.id(currentDocument.getKey());
            indexRequest.source(currentDocument.getValue(), XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        BulkResponse response = (BulkResponse)this.client.bulk(bulkRequest).actionGet();
        if (response.hasFailures()) {
            String details = "Index name '" + indexName + "', document ids " + sortedDocumentsIds + ", error details " + response.buildFailureMessage();
            throw new StepException("Cannot create document in index", StepExecutionStatus.CANNOT_BULK_CREATE_DOCUMENT_ERROR, details);
        }
    }

    public void flushIndex(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        FlushRequest request = new FlushRequest(new String[]{indexName});
        BroadcastResponse flushResponse = (BroadcastResponse)this.client.admin().indices().flush(request).actionGet();
        if (flushResponse.getFailedShards() > 0 || this.isFailure(flushResponse.getStatus())) {
            throw new StepException("Cannot flush index '" + indexName + "'.", StepExecutionStatus.CANNOT_REFRESH_INDEX_ERROR, null);
        }
    }

    public void refreshIndex(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        BroadcastResponse refreshResponse = (BroadcastResponse)this.client.admin().indices().refresh(new RefreshRequest(new String[]{indexName})).actionGet();
        if (refreshResponse.getFailedShards() > 0 || this.isFailure(refreshResponse.getStatus())) {
            throw new StepException("Cannot refresh index '" + indexName + "'.", StepExecutionStatus.CANNOT_REFRESH_INDEX_ERROR, null);
        }
    }

    public void deleteIndices(String ... indices) {
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)this.client.admin().indices().delete(new DeleteIndexRequest(indices)).actionGet();
        if (!acknowledgedResponse.isAcknowledged()) {
            String details = "Indices: " + Arrays.stream(indices).map(name -> "'" + name + "'").collect(Collectors.joining(", "));
            throw new StepException("Cannot delete indices ", StepExecutionStatus.CANNOT_DELETE_INDEX_ERROR, details);
        }
    }

    public BulkByScrollResponse reindexData(String sourceIndexName, String destinationIndexName) {
        Strings.requireNonEmpty((String)sourceIndexName, (String)"Source index name is required");
        Strings.requireNonEmpty((String)destinationIndexName, (String)"Destination index name is required");
        log.info("Try to reindex data from '{}' to '{}'", (Object)sourceIndexName, (Object)destinationIndexName);
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceBatchSize(100);
        reindexRequest.setSourceIndices(new String[]{sourceIndexName});
        reindexRequest.setDestIndex(destinationIndexName);
        reindexRequest.setDestOpType("create");
        reindexRequest.setRefresh(true);
        reindexRequest.setAbortOnVersionConflict(true);
        reindexRequest.setScroll(TimeValue.timeValueMinutes((long)5L));
        BulkByScrollResponse response = (BulkByScrollResponse)this.client.execute((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest).actionGet();
        log.debug("Reindex from '{}' to '{}' response '{}'", (Object)sourceIndexName, (Object)destinationIndexName, (Object)response);
        if (!response.getBulkFailures().isEmpty()) {
            String message = "Cannot reindex data from '" + sourceIndexName + "' to '" + destinationIndexName + "' due to bulk failures";
            throw new StepException(message, StepExecutionStatus.REINDEX_BULK_ERROR, null);
        }
        if (!response.getSearchFailures().isEmpty()) {
            String message = "Cannot reindex data from '" + sourceIndexName + "' to '" + destinationIndexName + "' due to search failures";
            throw new StepException(message, StepExecutionStatus.REINDEX_SEARCH_ERROR, null);
        }
        if (response.isTimedOut()) {
            String message = "Cannot reindex data from '" + sourceIndexName + "' to '" + destinationIndexName + "' due to timeout";
            throw new StepException(message, StepExecutionStatus.REINDEX_TIMEOUT_ERROR, null);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countDocuments(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        SearchRequest request = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource().size(0).trackTotalHits(true).query((QueryBuilder)QueryBuilders.matchAllQuery());
        request.source(sourceBuilder);
        SearchResponse response = (SearchResponse)this.client.search(request).actionGet();
        try {
            if (response.getFailedShards() > 0 || this.isFailure(response.status())) {
                throw new StepException("Cannot count documents in index '" + indexName + "'", StepExecutionStatus.CANNOT_COUNT_DOCUMENTS, null);
            }
            long l = response.getHits().getTotalHits().value();
            return l;
        }
        finally {
            response.decRef();
        }
    }

    public void updateMappings(String indexName, Map<String, ?> sources) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        PutMappingRequest request = new PutMappingRequest().indices(new String[]{indexName}).source(sources);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)this.client.admin().indices().putMapping(request).actionGet();
        if (!acknowledgedResponse.isAcknowledged()) {
            String details = "Cannot update mappings of index '" + indexName + "'";
            throw new StepException("Cannot delete indices ", StepExecutionStatus.CANNOT_UPDATE_MAPPINGS_ERROR, details);
        }
    }

    public BulkByScrollResponse deleteAllDocuments(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexName});
        request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        request.setRefresh(true);
        request.setBatchSize(100);
        request.setScroll(TimeValue.timeValueMinutes((long)5L));
        BulkByScrollResponse response = (BulkByScrollResponse)this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request).actionGet();
        if (!response.getBulkFailures().isEmpty()) {
            String message = "Cannot delete all documents from index '" + indexName + "' due to bulk error";
            throw new StepException(message, StepExecutionStatus.DELETE_ALL_BULK_ERROR, null);
        }
        if (!response.getSearchFailures().isEmpty()) {
            String message = "Cannot delete all documents from index '" + indexName + "' due to search error";
            throw new StepException(message, StepExecutionStatus.DELETE_ALL_SEARCH_ERROR, null);
        }
        if (response.isTimedOut()) {
            String message = "Cannot delete all documents from index '" + indexName + "' due to timeout";
            throw new StepException(message, StepExecutionStatus.DELETE_ALL_TIMEOUT_ERROR, null);
        }
        return response;
    }

    private boolean isSuccess(RestStatus restStatus) {
        return restStatus.getStatus() >= 200 && restStatus.getStatus() < 300;
    }

    private boolean isFailure(RestStatus restStatus) {
        return !this.isSuccess(restStatus);
    }
}

