/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections.views;

import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.fluent.collections.views.CollectionView;
import com.floragunn.fluent.collections.views.IteratorViewImpl;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.function.Function;

class CollectionViewImpl {
    CollectionViewImpl() {
    }

    static <ES, ET> CollectionView<ET> map(Collection<ES> set, Function<ES, ET> valueMappingFunction) {
        return new ValueRewritingCollectionView<ES, ET>(set, valueMappingFunction);
    }

    static class ValueRewritingCollectionView<ES, ET>
    extends AbstractCollection<ET>
    implements CollectionView<ET> {
        private final Collection<ES> source;
        private final Function<ES, ET> valueMappingFunction;

        public ValueRewritingCollectionView(Collection<ES> source, Function<ES, ET> valueMappingFunction) {
            this.source = source;
            this.valueMappingFunction = valueMappingFunction;
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public UnmodifiableIterator<ET> iterator() {
            return IteratorViewImpl.map(this.source.iterator(), this.valueMappingFunction);
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }
    }
}

