/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateBuilder {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final long MILLISECONDS_IN_MINUTE = 60000L;
    public static final long MILLISECONDS_IN_HOUR = 3600000L;
    public static final long SECONDS_IN_MOST_DAYS = 86400L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    private int month = -1;
    private int day = -1;
    private int year = -1;
    private int hour = -1;
    private int minute = -1;
    private int second = -1;
    private ZoneId zoneId;
    private Locale lc;
    private Clock clock = Clock.systemDefaultZone();

    private DateBuilder() {
        this(TimeZone.getDefault());
    }

    private DateBuilder(TimeZone tz) {
        this.zoneId = tz.toZoneId();
    }

    private DateBuilder(Locale lc) {
        this(Calendar.getInstance(lc).getTimeZone());
        this.lc = lc;
    }

    private DateBuilder(TimeZone tz, Locale lc) {
        this(Calendar.getInstance(tz, lc).getTimeZone());
        this.zoneId = tz.toZoneId();
        this.lc = lc;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    public static DateBuilder newDate() {
        return new DateBuilder();
    }

    public static DateBuilder newDateInTimezone(TimeZone tz) {
        return new DateBuilder(tz);
    }

    public static DateBuilder newDateInLocale(Locale lc) {
        return new DateBuilder(lc);
    }

    public static DateBuilder newDateInTimeZoneAndLocale(TimeZone tz, Locale lc) {
        return new DateBuilder(tz, lc);
    }

    public Date build() {
        ZonedDateTime zdt;
        ZoneId useZoneId;
        ZoneId zoneId = useZoneId = this.zoneId != null ? this.zoneId : ZoneId.systemDefault();
        if (this.lc != null && useZoneId == null) {
            useZoneId = Calendar.getInstance(this.lc).getTimeZone().toZoneId();
        }
        if (this.year == -1 || this.month == -1 || this.day == -1 || this.hour == -1 || this.minute == -1 || this.second == -1) {
            zdt = ZonedDateTime.now(this.clock).withZoneSameInstant(useZoneId);
            this.year = zdt.getYear();
            this.month = zdt.getMonthValue();
            this.day = zdt.getDayOfMonth();
            this.hour = zdt.getHour();
            this.minute = zdt.getMinute();
            this.second = zdt.getSecond();
        }
        zdt = ZonedDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, 0, useZoneId);
        return Date.from(zdt.toInstant());
    }

    public DateBuilder atHourOfDay(int atHour) {
        DateBuilder.validateHour(atHour);
        this.hour = atHour;
        return this;
    }

    public DateBuilder atMinute(int atMinute) {
        DateBuilder.validateMinute(atMinute);
        this.minute = atMinute;
        return this;
    }

    public DateBuilder atSecond(int atSecond) {
        DateBuilder.validateSecond(atSecond);
        this.second = atSecond;
        return this;
    }

    public DateBuilder atHourMinuteAndSecond(int atHour, int atMinute, int atSecond) {
        DateBuilder.validateHour(atHour);
        DateBuilder.validateMinute(atMinute);
        DateBuilder.validateSecond(atSecond);
        this.hour = atHour;
        this.second = atSecond;
        this.minute = atMinute;
        return this;
    }

    public DateBuilder onDay(int onDay) {
        DateBuilder.validateDayOfMonth(onDay);
        this.day = onDay;
        return this;
    }

    public DateBuilder inMonth(int inMonth) {
        DateBuilder.validateMonth(inMonth);
        this.month = inMonth;
        return this;
    }

    public DateBuilder inMonthOnDay(int inMonth, int onDay) {
        DateBuilder.validateMonth(inMonth);
        DateBuilder.validateDayOfMonth(onDay);
        this.month = inMonth;
        this.day = onDay;
        return this;
    }

    public DateBuilder inYear(int inYear) {
        DateBuilder.validateYear(inYear);
        this.year = inYear;
        return this;
    }

    public DateBuilder inTimeZone(TimeZone timezone) {
        this.zoneId = timezone.toZoneId();
        return this;
    }

    public DateBuilder inLocale(Locale locale) {
        this.lc = locale;
        return this;
    }

    public static Date futureDate(int interval, IntervalUnit unit) {
        return DateBuilder.futureDate(interval, unit, Clock.systemDefaultZone());
    }

    static Date futureDate(int interval, IntervalUnit unit, Clock clock) {
        return Date.from(ZonedDateTime.now(clock).plus(interval, DateBuilder.translate(unit)).toInstant());
    }

    private static ChronoUnit translate(IntervalUnit unit) {
        switch (unit) {
            case DAY: {
                return ChronoUnit.DAYS;
            }
            case HOUR: {
                return ChronoUnit.HOURS;
            }
            case MINUTE: {
                return ChronoUnit.MINUTES;
            }
            case MONTH: {
                return ChronoUnit.MONTHS;
            }
            case SECOND: {
                return ChronoUnit.SECONDS;
            }
            case MILLISECOND: {
                return ChronoUnit.MILLIS;
            }
            case WEEK: {
                return ChronoUnit.WEEKS;
            }
            case YEAR: {
                return ChronoUnit.YEARS;
            }
        }
        throw new IllegalArgumentException("Unknown IntervalUnit");
    }

    public static Date tomorrowAt(int hour, int minute, int second) {
        return DateBuilder.tomorrowAt(hour, minute, second, Clock.systemDefaultZone());
    }

    static Date tomorrowAt(int hour, int minute, int second, Clock clock) {
        return Date.from(ZonedDateTime.now(clock).truncatedTo(ChronoUnit.DAYS).plusHours(24L).with(LocalTime.of(hour, minute, second, 0)).toInstant());
    }

    public static Date todayAt(int hour, int minute, int second) {
        return DateBuilder.todayAt(hour, minute, second, Clock.systemDefaultZone());
    }

    static Date todayAt(int hour, int minute, int second, Clock clock) {
        return DateBuilder.dateOf(hour, minute, second, clock);
    }

    public static Date dateOf(int hour, int minute, int second) {
        return DateBuilder.dateOf(hour, minute, second, Clock.systemDefaultZone());
    }

    static Date dateOf(int hour, int minute, int second, Clock clock) {
        return Date.from(ZonedDateTime.now(clock).with(LocalTime.of(hour, minute, second, 0)).toInstant());
    }

    public static Date dateOf(int hour, int minute, int second, int dayOfMonth, int month) {
        return DateBuilder.dateOf(hour, minute, second, dayOfMonth, month, Clock.systemDefaultZone());
    }

    static Date dateOf(int hour, int minute, int second, int dayOfMonth, int month, Clock clock) {
        ZonedDateTime zdt = ZonedDateTime.now(clock);
        return Date.from(zdt.with(LocalDateTime.of(zdt.getYear(), month, dayOfMonth, hour, minute, second, 0)).toInstant());
    }

    public static Date dateOf(int hour, int minute, int second, int dayOfMonth, int month, int year) {
        return DateBuilder.dateOf(hour, minute, second, dayOfMonth, month, year, Clock.systemDefaultZone());
    }

    static Date dateOf(int hour, int minute, int second, int dayOfMonth, int month, int year, Clock clock) {
        return Date.from(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, 0).atZone(clock.getZone()).toInstant());
    }

    public static Date evenHourDateAfterNow() {
        return DateBuilder.evenHourDateAfterNow(Clock.systemDefaultZone());
    }

    static Date evenHourDateAfterNow(Clock clock) {
        return DateBuilder.evenHourDate(null, clock);
    }

    public static Date evenHourDate(Date date) {
        return DateBuilder.evenHourDate(date, Clock.systemDefaultZone());
    }

    static Date evenHourDate(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        zdt = zdt.plusHours(1L);
        return Date.from(zdt.truncatedTo(ChronoUnit.HOURS).toInstant());
    }

    public static Date evenHourDateBefore(Date date) {
        return DateBuilder.evenHourDateBefore(date, Clock.systemDefaultZone());
    }

    static Date evenHourDateBefore(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        return Date.from(zdt.truncatedTo(ChronoUnit.HOURS).toInstant());
    }

    public static Date evenMinuteDateAfterNow() {
        return DateBuilder.evenMinuteDateAfterNow(Clock.systemDefaultZone());
    }

    static Date evenMinuteDateAfterNow(Clock clock) {
        return DateBuilder.evenMinuteDate(null, clock);
    }

    public static Date evenMinuteDate(Date date) {
        return DateBuilder.evenMinuteDate(date, Clock.systemDefaultZone());
    }

    public static Date evenMinuteDate(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        zdt = zdt.plusMinutes(1L);
        return Date.from(zdt.truncatedTo(ChronoUnit.MINUTES).toInstant());
    }

    public static Date evenMinuteDateBefore(Date date) {
        return DateBuilder.evenMinuteDateBefore(date, Clock.systemDefaultZone());
    }

    static Date evenMinuteDateBefore(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        return Date.from(zdt.truncatedTo(ChronoUnit.MINUTES).toInstant());
    }

    public static Date evenSecondDateAfterNow() {
        return DateBuilder.evenSecondDateAfterNow(Clock.systemDefaultZone());
    }

    static Date evenSecondDateAfterNow(Clock clock) {
        return DateBuilder.evenSecondDate(null, clock);
    }

    public static Date evenSecondDate(Date date) {
        return DateBuilder.evenSecondDate(date, Clock.systemDefaultZone());
    }

    static Date evenSecondDate(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        zdt = zdt.plusSeconds(1L);
        return Date.from(zdt.truncatedTo(ChronoUnit.SECONDS).toInstant());
    }

    public static Date evenSecondDateBefore(Date date) {
        return DateBuilder.evenSecondDateBefore(date, Clock.systemDefaultZone());
    }

    static Date evenSecondDateBefore(Date date, Clock clock) {
        ZonedDateTime zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        return Date.from(zdt.truncatedTo(ChronoUnit.SECONDS).toInstant());
    }

    public static Date nextGivenMinuteDate(Date date, int minuteBase) {
        return DateBuilder.nextGivenMinuteDate(date, minuteBase, Clock.systemDefaultZone());
    }

    static Date nextGivenMinuteDate(Date date, int minuteBase, Clock clock) {
        ZonedDateTime zdt;
        if (minuteBase < 0 || minuteBase > 59) {
            throw new IllegalArgumentException("minuteBase must be >=0 and <= 59");
        }
        ZonedDateTime zonedDateTime = zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        if (minuteBase == 0) {
            zdt = zdt.truncatedTo(ChronoUnit.HOURS).plusHours(1L);
            return Date.from(zdt.toInstant());
        }
        int minute = (zdt = zdt.truncatedTo(ChronoUnit.MINUTES)).getMinute();
        int nextminute = minute + minuteBase - minute % minuteBase;
        zdt = nextminute >= 60 ? zdt.truncatedTo(ChronoUnit.HOURS).plusHours(1L) : zdt.withMinute(nextminute);
        return Date.from(zdt.toInstant());
    }

    public static Date nextGivenSecondDate(Date date, int secondBase) {
        return DateBuilder.nextGivenSecondDate(date, secondBase, Clock.systemDefaultZone());
    }

    static Date nextGivenSecondDate(Date date, int secondBase, Clock clock) {
        ZonedDateTime zdt;
        if (secondBase < 0 || secondBase > 59) {
            throw new IllegalArgumentException("secondBase must be >=0 and <= 59");
        }
        ZonedDateTime zonedDateTime = zdt = date == null ? ZonedDateTime.now(clock) : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        if (secondBase == 0) {
            zdt = zdt.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L);
            return Date.from(zdt.toInstant());
        }
        int second = (zdt = zdt.truncatedTo(ChronoUnit.SECONDS)).getSecond();
        int nextSecond = second + secondBase - second % secondBase;
        zdt = nextSecond >= 60 ? zdt.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L) : zdt.withSecond(nextSecond);
        return Date.from(zdt.toInstant());
    }

    public static Date translateTime(Date date, TimeZone src, TimeZone dest) {
        Date newDate = new Date();
        int offset = dest.getOffset(date.getTime()) - src.getOffset(date.getTime());
        newDate.setTime(date.getTime() - (long)offset);
        return newDate;
    }

    public static void validateDayOfWeek(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("Invalid day of week.");
        }
    }

    public static void validateHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour (must be >= 0 and <= 23).");
        }
    }

    public static void validateMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute (must be >= 0 and <= 59).");
        }
    }

    public static void validateSecond(int second) {
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second (must be >= 0 and <= 59).");
        }
    }

    public static void validateDayOfMonth(int day) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day of month.");
        }
    }

    public static void validateMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month (must be >= 1 and <= 12.");
        }
    }

    public static void validateYear(int year) {
        if (year < 1970 || year > 999999999) {
            throw new IllegalArgumentException("Invalid year (must be >= 0 and <= 999999999");
        }
    }

    public static enum IntervalUnit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

