/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.write;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class ComplianceIndexTemplateActionFilter
implements ActionFilter {
    private static final Logger log = LogManager.getLogger(ComplianceIndexTemplateActionFilter.class);
    private final AuditLogConfig auditLogConfig;
    private final AuditLog auditLog;
    private final ClusterService clusterService;

    public ComplianceIndexTemplateActionFilter(AuditLogConfig auditLogConfig, AuditLog auditLog, ClusterService clusterService) {
        this.auditLogConfig = auditLogConfig;
        this.auditLog = auditLog;
        this.clusterService = clusterService;
    }

    public int order() {
        return 2;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        ActionListener<Response> actualListener = listener;
        if (this.shouldProceed(task)) {
            if (request instanceof TransportPutComposableIndexTemplateAction.Request) {
                TransportPutComposableIndexTemplateAction.Request putIndexTemplateRequest = (TransportPutComposableIndexTemplateAction.Request)request;
                actualListener = new PutIndexTemplateListenerWrapper<Response>(action, putIndexTemplateRequest, listener);
            } else if (request instanceof PutIndexTemplateRequest) {
                PutIndexTemplateRequest putIndexTemplateRequest = (PutIndexTemplateRequest)request;
                actualListener = new PutIndexTemplateListenerWrapper<Response>(action, putIndexTemplateRequest, listener);
            } else if (request instanceof TransportDeleteComposableIndexTemplateAction.Request) {
                TransportDeleteComposableIndexTemplateAction.Request deleteIndexTemplateRequest = (TransportDeleteComposableIndexTemplateAction.Request)request;
                actualListener = new DeleteIndexTemplateListenerWrapper<Response>(action, deleteIndexTemplateRequest, listener);
            } else if (request instanceof DeleteIndexTemplateRequest) {
                DeleteIndexTemplateRequest deleteIndexTemplateRequest = (DeleteIndexTemplateRequest)request;
                actualListener = new DeleteIndexTemplateListenerWrapper<Response>(action, deleteIndexTemplateRequest, listener);
            }
        }
        chain.proceed(task, action, request, actualListener);
    }

    private boolean shouldProceed(Task task) {
        return this.auditLogConfig.isEnabled() && !task.getParentTaskId().isSet();
    }

    private ComposableIndexTemplate getComposableIndexTemplateCurrentState(String indexTemplateName) {
        return (ComposableIndexTemplate)this.clusterService.state().metadata().getProject().templatesV2().get(indexTemplateName);
    }

    private IndexTemplateMetadata getLegacyIndexTemplateCurrentState(String indexTemplateName) {
        return (IndexTemplateMetadata)this.clusterService.state().metadata().getProject().templates().get(indexTemplateName);
    }

    private class PutIndexTemplateListenerWrapper<Response>
    implements ActionListener<Response> {
        private final String action;
        private final String templateName;
        private final TransportRequest request;
        private final ActionListener<Response> originalListener;
        private final ComposableIndexTemplate originalComposableIndexTemplate;
        private final IndexTemplateMetadata originalLegacyIndexTemplate;
        private final boolean legacyTemplate;

        private PutIndexTemplateListenerWrapper(String action, TransportPutComposableIndexTemplateAction.Request request, ActionListener<Response> originalListener) {
            this.action = action;
            this.templateName = request.name();
            this.request = request;
            this.originalListener = originalListener;
            this.originalComposableIndexTemplate = ComplianceIndexTemplateActionFilter.this.getComposableIndexTemplateCurrentState(request.name());
            this.originalLegacyIndexTemplate = null;
            this.legacyTemplate = false;
        }

        private PutIndexTemplateListenerWrapper(String action, PutIndexTemplateRequest request, ActionListener<Response> originalListener) {
            this.action = action;
            this.templateName = request.name();
            this.request = request;
            this.originalListener = originalListener;
            this.originalComposableIndexTemplate = null;
            this.originalLegacyIndexTemplate = ComplianceIndexTemplateActionFilter.this.getLegacyIndexTemplateCurrentState(request.name());
            this.legacyTemplate = true;
        }

        public void onResponse(Response response) {
            try {
                if (this.legacyTemplate) {
                    IndexTemplateMetadata currentTemplate = ComplianceIndexTemplateActionFilter.this.getLegacyIndexTemplateCurrentState(this.templateName);
                    ComplianceIndexTemplateActionFilter.this.auditLog.logIndexTemplatePutted(this.templateName, this.originalLegacyIndexTemplate, currentTemplate, this.action, this.request);
                } else {
                    ComposableIndexTemplate currentTemplate = ComplianceIndexTemplateActionFilter.this.getComposableIndexTemplateCurrentState(this.templateName);
                    ComplianceIndexTemplateActionFilter.this.auditLog.logIndexTemplatePutted(this.templateName, this.originalComposableIndexTemplate, currentTemplate, this.action, this.request);
                }
                this.originalListener.onResponse(response);
            }
            catch (Exception e) {
                log.debug("An error occurred while logging index template '{}' putted audit message", (Object)this.templateName, (Object)e);
                this.originalListener.onResponse(response);
            }
        }

        public void onFailure(Exception e) {
            this.originalListener.onFailure(e);
        }
    }

    private class DeleteIndexTemplateListenerWrapper<Response>
    implements ActionListener<Response> {
        private final String action;
        private final List<String> templateNames;
        private final TransportRequest request;
        private final ActionListener<Response> originalListener;

        private DeleteIndexTemplateListenerWrapper(String action, TransportDeleteComposableIndexTemplateAction.Request request, ActionListener<Response> originalListener) {
            this.action = action;
            this.templateNames = Arrays.asList(request.names());
            this.request = request;
            this.originalListener = originalListener;
        }

        private DeleteIndexTemplateListenerWrapper(String action, DeleteIndexTemplateRequest request, ActionListener<Response> originalListener) {
            this.action = action;
            this.templateNames = Collections.singletonList(request.name());
            this.request = request;
            this.originalListener = originalListener;
        }

        public void onResponse(Response response) {
            try {
                ComplianceIndexTemplateActionFilter.this.auditLog.logIndexTemplateDeleted(this.templateNames, this.action, this.request);
                this.originalListener.onResponse(response);
            }
            catch (Exception e) {
                log.debug("An error occurred while logging index templates '{}' deleted audit message", this.templateNames, (Object)e);
                this.originalListener.onResponse(response);
            }
        }

        public void onFailure(Exception e) {
            this.originalListener.onFailure(e);
        }
    }
}

