/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.client;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchsupport.client.Actions;
import com.floragunn.searchsupport.client.RefCountedGuard;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;

public class SearchScroller {
    private static final Logger log = LogManager.getLogger(SearchScroller.class);
    private final Client client;

    public SearchScroller(Client client) {
        this.client = Objects.requireNonNull(client, "Client is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void scroll(SearchRequest request, TimeValue scrollTime, Function<SearchHit, T> resultMapper, Consumer<ImmutableList<T>> resultConsumer) {
        Objects.requireNonNull(request, "Search request is required to scroll");
        Objects.requireNonNull(resultMapper, "Scroll result mapper is required");
        request.scroll(scrollTime);
        try (RefCountedGuard<SearchResponse> guard = new RefCountedGuard<SearchResponse>();){
            SearchResponse searchResponse = (SearchResponse)this.client.search(request).actionGet();
            guard.add(searchResponse);
            try {
                do {
                    SearchHit[] hits = searchResponse.getHits().getHits();
                    String scrollId = searchResponse.getScrollId();
                    if (searchResponse.getFailedShards() > 0) {
                        throw new IllegalStateException("Unexpected error during scrolling via search results.");
                    }
                    log.debug("'{}' elements were gained due to scrolling with id '{}'.", (Object)hits.length, (Object)scrollId);
                    ArrayList<T> mutableResultList = new ArrayList<T>();
                    for (SearchHit searchHit : hits) {
                        mutableResultList.add(resultMapper.apply(searchHit));
                    }
                    resultConsumer.accept(ImmutableList.of(mutableResultList));
                    guard.release();
                    searchResponse = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(scrollTime).execute().actionGet();
                    guard.add(searchResponse);
                } while (searchResponse.getHits().getHits().length != 0);
            }
            finally {
                log.debug("Async clear scroll '{}'.", (Object)searchResponse.getScrollId());
                Actions.clearScrollAsync(this.client, searchResponse);
            }
        }
        catch (ElasticsearchException e) {
            log.error("Error during scrolling to load all search results", (Throwable)e);
            throw e;
        }
    }
}

