/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.accounts;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.watch.action.handlers.email.EmailAccount;
import com.floragunn.signals.watch.action.handlers.slack.SlackAccount;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;

public abstract class Account
implements ToXContentObject {
    private String id;
    public static final FactoryRegistry factoryRegistry = new FactoryRegistry(new EmailAccount.Factory(), new SlackAccount.Factory());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUse(Client client, SignalsSettings settings) {
        String indexName = settings.getStaticSettings().getIndexNames().getWatches();
        SearchRequest request = new SearchRequest(new String[]{indexName}).source(this.getReferencingWatchesQuery());
        SearchResponse searchResponse = (SearchResponse)client.search(request).actionGet();
        try {
            long hits = searchResponse.getHits().getTotalHits().value();
            boolean bl = hits > 0L;
            return bl;
        }
        finally {
            searchResponse.decRef();
        }
    }

    public void isInUse(Client client, SignalsSettings settings, final ActionListener<Boolean> actionListener) {
        client.search(new SearchRequest(new String[]{settings.getStaticSettings().getIndexNames().getWatches()}).source(this.getReferencingWatchesQuery()).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN), (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.getHits().getTotalHits().value() > 0L) {
                    actionListener.onResponse((Object)Boolean.TRUE);
                } else {
                    actionListener.onResponse((Object)Boolean.FALSE);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public abstract SearchSourceBuilder getReferencingWatchesQuery();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getScopedId() {
        return this.getType() + "/" + this.id;
    }

    public abstract String getType();

    public final String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public static Account parse(String accountType, String id, String string) throws ConfigValidationException {
        return Account.create(accountType, id, DocNode.parse((Format)Format.JSON).from(string));
    }

    public static Account create(String accountType, String id, DocNode jsonNode) throws ConfigValidationException {
        Factory<?> factory = factoryRegistry.get(accountType);
        if (factory == null) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("type", (Object)accountType, (Object)factoryRegistry.getFactoryNames()));
        }
        return factory.create(id, jsonNode);
    }

    public static final class FactoryRegistry {
        private final Map<String, Factory<?>> factories = new HashMap();
        private String factoryNames;

        FactoryRegistry(Factory<?> ... factories) {
            this.add(factories);
        }

        private void internalAddFactory(Factory<?> factory) {
            if (factory.getType() == null) {
                throw new IllegalArgumentException("type of factory is null: " + String.valueOf(factory));
            }
            if (this.factories.containsKey(factory.getType())) {
                throw new IllegalStateException("Factory of type " + factory.getType() + " (" + String.valueOf(factory) + ") was already installed: " + String.valueOf(this.factories));
            }
            this.factories.put(factory.getType().toLowerCase(), factory);
        }

        public void add(Factory<?> ... factories) {
            for (Factory<?> factory : factories) {
                this.internalAddFactory(factory);
            }
            this.factoryNames = String.join((CharSequence)"|", new TreeSet<String>(this.factories.keySet()));
        }

        public <A extends Account> Factory<A> get(Class<A> implClass) {
            for (Factory<?> factory : this.factories.values()) {
                if (!factory.getImplClass().equals(implClass)) continue;
                Factory<?> result = factory;
                return result;
            }
            return null;
        }

        Factory<?> get(String type) {
            return this.factories.get(type.toLowerCase());
        }

        String getFactoryNames() {
            return this.factoryNames;
        }
    }

    public static abstract class Factory<A extends Account> {
        private final String type;

        protected Factory(String type) {
            this.type = type;
        }

        public final A create(String id, DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(docNode, validationErrors);
            vJsonNode.used(new String[]{"type", "_name"});
            A result = this.create(id, vJsonNode, validationErrors);
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public final A create(String id, ValidatingDocNode vJsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            vJsonNode = new ValidatingDocNode(vJsonNode, validationErrors);
            vJsonNode.used(new String[]{"type", "_name"});
            A result = this.create(id, vJsonNode, validationErrors);
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        protected abstract A create(String var1, ValidatingDocNode var2, ValidationErrors var3) throws ConfigValidationException;

        public abstract Class<A> getImplClass();

        public String getType() {
            return this.type;
        }
    }
}

