/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.search;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.account.search.SearchAccountRequest;
import com.floragunn.signals.actions.account.search.SearchAccountResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAccountAction
extends HandledTransportAction<SearchAccountRequest, SearchAccountResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchAccountAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:account/search", transportService, actionFilters, SearchAccountRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, SearchAccountRequest request, final ActionListener<SearchAccountResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                throw new Exception("No user set");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                throw new Exception("Unknown tenant: " + user.getRequestedTenant());
            }
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            Map originalResponseHeaders = threadContext.getResponseHeaders();
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                SearchSourceBuilder searchSourceBuilder;
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                SearchRequest searchRequest = new SearchRequest(new String[]{this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getAccounts()});
                if (request.getScroll() != null) {
                    searchRequest.scroll(request.getScroll());
                }
                if ((searchSourceBuilder = request.getSearchSourceBuilder()) == null) {
                    searchSourceBuilder = new SearchSourceBuilder();
                    searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
                }
                if (request.getFrom() != -1) {
                    searchSourceBuilder.from(request.getFrom());
                }
                if (request.getSize() != -1) {
                    searchSourceBuilder.size(request.getSize());
                }
                searchRequest.source(searchSourceBuilder);
                this.client.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        ActionListener.respondAndRelease((ActionListener)listener, (RefCounted)new SearchAccountResponse(response));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

