/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.service;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.proxy.rest.ProxyApi;
import com.floragunn.signals.proxy.rest.ProxyRepresentation;
import com.floragunn.signals.proxy.service.NoSuchProxyException;
import com.floragunn.signals.proxy.service.persistence.ProxyData;
import com.floragunn.signals.proxy.service.persistence.ProxyRepository;
import com.floragunn.signals.watch.common.ProxyTypeProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.elasticsearch.common.Strings;

public class ProxyCrudService {
    private final ProxyRepository proxyRepository;

    public ProxyCrudService(ProxyRepository proxyRepository) {
        this.proxyRepository = proxyRepository;
    }

    public StandardResponse createOrReplace(ProxyApi.CreateOrReplaceProxyAction.CreateOrReplaceProxyRequest request) throws ConfigValidationException {
        ProxyData proxyData = this.toProxyData(request);
        this.proxyRepository.createOrReplace(proxyData);
        return new StandardResponse(200).data(ProxyRepresentation.of(proxyData).toBasicObject());
    }

    public StandardResponse findOne(String proxyId) throws NoSuchProxyException {
        Objects.requireNonNull(proxyId, "Proxy id is required");
        return this.proxyRepository.findOneById(proxyId).map(ProxyRepresentation::of).map(ProxyRepresentation::toBasicObject).map(proxyRepresentation -> new StandardResponse(200).data(proxyRepresentation)).orElseThrow(() -> new NoSuchProxyException("Proxy with id '" + proxyId + "' not found."));
    }

    public StandardResponse delete(String proxyId) {
        Objects.requireNonNull(proxyId, "Proxy id is required");
        if (this.proxyRepository.isProxyUsedByAnyWatch(proxyId)) {
            return new StandardResponse(409).error("The proxy is still in use");
        }
        return this.proxyRepository.deleteById(proxyId) != false ? new StandardResponse(200) : new StandardResponse(404);
    }

    public StandardResponse findAll() {
        List proxies = this.proxyRepository.findAll().stream().map(ProxyRepresentation::of).map(ProxyRepresentation::toBasicObject).collect(Collectors.toList());
        return new StandardResponse(200).data(proxies);
    }

    Optional<ProxyData> findOneById(String proxyId) {
        return this.proxyRepository.findOneById(proxyId);
    }

    List<ProxyData> loadAll() {
        return this.proxyRepository.findAll();
    }

    private ProxyData toProxyData(ProxyApi.CreateOrReplaceProxyAction.CreateOrReplaceProxyRequest request) throws ConfigValidationException {
        String id = request.getId();
        String name = request.getName();
        String uri = request.getUri();
        ValidationErrors validationErrors = new ValidationErrors();
        if (Strings.isNullOrEmpty((String)id)) {
            validationErrors.add(new ValidationError("id", "Id is required"));
        }
        if (ProxyTypeProvider.determineTypeBasedOnValue(id) != ProxyTypeProvider.Type.USE_STORED_PROXY) {
            String expectedMsg = String.format("String not equal to any of: (%s, %s) and not starting with any of: (%s)", "default", "none", String.join((CharSequence)", ", ProxyTypeProvider.INLINE_PROXY_PREFIXES));
            validationErrors.add((ValidationError)new InvalidAttributeValue("id", (Object)id, (Object)expectedMsg));
        }
        try {
            HttpHost.create((String)uri);
        }
        catch (Exception e) {
            validationErrors.add((ValidationError)new InvalidAttributeValue("uri", (Object)uri, (Object)"Valid URI"));
        }
        validationErrors.throwExceptionForPresentErrors();
        return new ProxyData(id, name, uri);
    }
}

