/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.state;

import com.floragunn.signals.watch.state.WatchState;
import com.floragunn.signals.watch.state.WatchStateWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class WatchStateIndexWriter
implements WatchStateWriter<DocWriteResponse> {
    private static final Logger log = LogManager.getLogger(WatchStateIndexWriter.class);
    private final String indexName;
    private final String watchIdPrefix;
    private final Client client;

    public WatchStateIndexWriter(String watchIdPrefix, String indexName, Client client) {
        this.watchIdPrefix = watchIdPrefix;
        this.indexName = indexName;
        this.client = client;
    }

    @Override
    public void put(final String watchId, final WatchState watchState) {
        try {
            this.put(watchId, watchState, new ActionListener<DocWriteResponse>(){

                public void onResponse(DocWriteResponse response) {
                    if (log.isDebugEnabled()) {
                        log.debug("Updated " + watchId + " to:\n" + String.valueOf(watchState) + "\n" + Strings.toString((ToXContent)response));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Error while writing WatchState " + String.valueOf(watchState), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error while writing WatchState " + String.valueOf(watchState), (Throwable)e);
        }
    }

    @Override
    public void put(String watchId, WatchState watchState, ActionListener<DocWriteResponse> actionListener) {
        IndexRequest indexRequest = this.createIndexRequest(watchId, watchState, WriteRequest.RefreshPolicy.IMMEDIATE, null);
        this.client.index(indexRequest, actionListener);
    }

    @Override
    public void putAll(final Map<String, WatchState> idToStateMap) {
        BulkRequest bulkRequest = new BulkRequest();
        for (Map.Entry<String, WatchState> entry : idToStateMap.entrySet()) {
            try {
                bulkRequest.add(this.createIndexRequest(entry.getKey(), entry.getValue(), WriteRequest.RefreshPolicy.NONE, null));
            }
            catch (Exception e) {
                log.error("Error while serializing " + String.valueOf(entry));
            }
        }
        this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                if (log.isDebugEnabled()) {
                    log.debug("Updated " + String.valueOf(idToStateMap.keySet()) + "\n" + Strings.toString((ChunkedToXContent)response));
                }
            }

            public void onFailure(Exception e) {
                log.error("Error while writing WatchState " + String.valueOf(idToStateMap), (Throwable)e);
            }
        });
    }

    private IndexRequest createIndexRequest(String watchId, WatchState watchState, WriteRequest.RefreshPolicy refreshPolicy, DocWriteRequest.OpType opType) {
        IndexRequest indexRequest;
        block9: {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            try {
                IndexRequest indexRequest2 = new IndexRequest(this.indexName).id(this.watchIdPrefix + watchId);
                if (opType != null) {
                    indexRequest2.opType(opType);
                }
                watchState.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
                indexRequest2.source(jsonBuilder);
                indexRequest2.setRefreshPolicy(refreshPolicy);
                indexRequest = indexRequest2;
                if (jsonBuilder == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonBuilder != null) {
                        try {
                            jsonBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonBuilder.close();
        }
        return indexRequest;
    }

    public void putIfAbsent(final String watchId, final WatchState watchState) {
        try {
            this.put(watchId, watchState, new ActionListener<DocWriteResponse>(){

                public void onResponse(DocWriteResponse response) {
                    if (log.isDebugEnabled()) {
                        log.debug("Updated " + watchId + " to:\n" + String.valueOf(watchState) + "\n" + Strings.toString((ToXContent)response));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Error while writing WatchState " + String.valueOf(watchState), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error while writing WatchState " + String.valueOf(watchState), (Throwable)e);
        }
    }

    public void putIfAbsent(String watchId, WatchState watchState, ActionListener<DocWriteResponse> actionListener) {
        IndexRequest indexRequest = this.createIndexRequest(watchId, watchState, WriteRequest.RefreshPolicy.IMMEDIATE, DocWriteRequest.OpType.CREATE);
        this.client.index(indexRequest, actionListener);
    }
}

