/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.util.SSLConfigConstants;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;

public class ExternalSearchGuardKeyStore
implements SearchGuardKeyStore {
    private static final String EXTERNAL = "EXTERNAL";
    private static final Map<String, SSLContext> contextMap = new ConcurrentHashMap<String, SSLContext>();
    private final SSLContext externalSslContext;
    private final Settings settings;

    public ExternalSearchGuardKeyStore(Settings settings) {
        this.settings = Objects.requireNonNull(settings);
        String externalContextId = settings.get("searchguard.ssl.client.external_context_id", null);
        if (externalContextId == null || externalContextId.length() == 0) {
            throw new ElasticsearchException("no external ssl context id was set", new Object[0]);
        }
        this.externalSslContext = contextMap.get(externalContextId);
        if (this.externalSslContext == null) {
            throw new ElasticsearchException("no external ssl context for id " + externalContextId, new Object[0]);
        }
    }

    @Override
    public SSLEngine createHTTPSSLEngine() throws SSLException {
        throw new SSLException("not implemented");
    }

    @Override
    public SSLEngine createServerTransportSSLEngine() throws SSLException {
        throw new SSLException("not implemented");
    }

    @Override
    public SSLEngine createClientTransportSSLEngine(String peerHost, int peerPort) throws SSLException {
        if (peerHost != null) {
            SSLEngine engine = this.externalSslContext.createSSLEngine(peerHost, peerPort);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParams);
            engine.setEnabledProtocols(this.evalSecure(engine.getEnabledProtocols(), SSLConfigConstants.getSecureSSLProtocols(this.settings, false)));
            engine.setEnabledCipherSuites(this.evalSecure(engine.getEnabledCipherSuites(), SSLConfigConstants.getSecureSSLCiphers(this.settings, false).toArray(new String[0])));
            engine.setUseClientMode(true);
            return engine;
        }
        SSLEngine engine = this.externalSslContext.createSSLEngine();
        engine.setEnabledProtocols(this.evalSecure(engine.getEnabledProtocols(), SSLConfigConstants.getSecureSSLProtocols(this.settings, false)));
        engine.setEnabledCipherSuites(this.evalSecure(engine.getEnabledCipherSuites(), SSLConfigConstants.getSecureSSLCiphers(this.settings, false).toArray(new String[0])));
        engine.setUseClientMode(true);
        return engine;
    }

    @Override
    public String getHTTPProviderName() {
        return null;
    }

    @Override
    public String getTransportServerProviderName() {
        return null;
    }

    @Override
    public String getTransportClientProviderName() {
        return EXTERNAL;
    }

    @Override
    public void initHttpSSLConfig() {
    }

    @Override
    public void initTransportSSLConfig() {
    }

    @Override
    public X509Certificate[] getHttpCerts() {
        return new X509Certificate[0];
    }

    @Override
    public X509Certificate[] getTransportCerts() {
        return new X509Certificate[0];
    }

    public static void registerExternalSslContext(String id, SSLContext externalSsslContext) {
        contextMap.put(Objects.requireNonNull(id), Objects.requireNonNull(externalSsslContext));
    }

    public static boolean hasExternalSslContext(Settings settings) {
        String externalContextId = settings.get("searchguard.ssl.client.external_context_id", null);
        if (externalContextId == null || externalContextId.length() == 0) {
            return false;
        }
        return contextMap.containsKey(externalContextId);
    }

    public static boolean hasExternalSslContext(String id) {
        return contextMap.containsKey(id);
    }

    public static void removeExternalSslContext(String id) {
        contextMap.remove(id);
    }

    public static void removeAllExternalSslContexts() {
        contextMap.clear();
    }

    private String[] evalSecure(String[] engineEnabled, String[] secure) {
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(engineEnabled));
        tmp.retainAll(Arrays.asList(secure));
        return tmp.toArray(new String[0]);
    }
}

