/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.FailureReason;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;

public final class EmailValidationResult {
    private final boolean success;
    private final Email emailAddress;
    private final FailureReason failureReason;

    EmailValidationResult(boolean success, Email emailAddress, FailureReason failureReason) {
        this.success = success;
        this.emailAddress = emailAddress;
        this.failureReason = failureReason;
    }

    static EmailValidationResult failure(FailureReason failureReason) {
        return new EmailValidationResult(false, null, failureReason);
    }

    static EmailValidationResult success(Email email) {
        return new EmailValidationResult(true, email, FailureReason.NONE);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public Optional<Email> getEmail() {
        return Optional.ofNullable(this.emailAddress);
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public void ifValid(Consumer<Email> action) {
        if (this.emailAddress != null) {
            action.accept(this.emailAddress);
        }
    }

    public void ifValidOrElse(Consumer<Email> action, Consumer<FailureReason> failureAction) {
        if (this.emailAddress != null) {
            action.accept(this.emailAddress);
        } else {
            failureAction.accept(this.failureReason);
        }
    }

    public String toString() {
        return new StringJoiner(", ", EmailValidationResult.class.getSimpleName() + "[", "]").add("success=" + this.success).add("emailAddress=" + this.emailAddress).add("failureReason=" + (Object)((Object)this.failureReason)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailValidationResult)) {
            return false;
        }
        EmailValidationResult that = (EmailValidationResult)o;
        return Objects.equals(this.success, that.success) && Objects.equals(this.emailAddress, that.emailAddress) && Objects.equals((Object)this.failureReason, (Object)that.failureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.success, this.emailAddress, this.failureReason});
    }
}

