/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.kerberos;

import java.nio.file.Path;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class KeytabJaasConf
extends Configuration {
    private final String principal;
    private final Path keytabPath;
    private final boolean initiator;
    private final boolean debug;

    public KeytabJaasConf(String principal, Path keytab, boolean initiator, boolean debug) {
        this.principal = principal;
        this.keytabPath = keytab;
        this.initiator = initiator;
        this.debug = debug;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("keyTab", this.keytabPath.toAbsolutePath().toString());
        options.put("principal", this.principal);
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("doNotPrompt", "true");
        options.put("renewTGT", "false");
        options.put("refreshKrb5Config", "true");
        options.put("isInitiator", String.valueOf(this.initiator));
        options.put("debug", String.valueOf(this.debug));
        return new AppConfigurationEntry[]{new AppConfigurationEntry(KeytabJaasConf.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    private static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    public String toString() {
        return "KeytabJaasConf [principal=" + this.principal + ", keytabPath=" + String.valueOf(this.keytabPath) + ", initiator=" + this.initiator + ", debug=" + this.debug + "]";
    }
}

