/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public final class Preconditions {
    private Preconditions() {
    }

    @NotNull
    public static <T> T checkNonEmptyArgument(@Nullable T arg, @NotNull String parameterName) {
        return Preconditions.verifyNonnullOrEmpty(arg, String.format("%s is required", parameterName));
    }

    @NotNull
    public static <T> T verifyNonnull(@Nullable T arg) {
        if (arg == null) {
            throw new IllegalArgumentException("argument was assumed nonNull, but was null");
        }
        return arg;
    }

    @NotNull
    public static <T> T verifyNonnullOrEmpty(@Nullable T arg) {
        return Preconditions.verifyNonnullOrEmpty(arg, "argument was assumed nonNull and nonEmpty, but was null or empty");
    }

    @NotNull
    private static <T> T verifyNonnullOrEmpty(@Nullable T arg, @NotNull String message) {
        if (MiscUtil.valueNullOrEmpty(arg)) {
            throw new IllegalArgumentException(message);
        }
        return arg;
    }

    public static boolean assumeTrue(boolean state, @NotNull String msg) {
        if (!state) {
            throw new IllegalArgumentException(msg);
        }
        return true;
    }
}

