/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import com.floragunn.searchguard.lpg.FingerprintUtil;
import com.floragunn.searchguard.lpg.MPInteger;
import com.floragunn.searchguard.lpg.PublicKeyAlgorithmTags;
import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.Streams;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PublicKeyEncSessionPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_6 = 6;
    private int version;
    private long keyID;
    private int algorithm;
    private byte[][] data;
    private int keyVersion;
    private byte[] keyFingerprint;

    PublicKeyEncSessionPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    PublicKeyEncSessionPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(1, newPacketFormat);
        this.version = in.read();
        if (this.version == 3) {
            this.keyID = StreamUtil.readKeyID(in);
        } else if (this.version == 6) {
            int keyInfoLen = in.read();
            if (keyInfoLen == 0) {
                this.keyVersion = 0;
                this.keyFingerprint = new byte[0];
                this.keyID = 0L;
            } else {
                this.keyVersion = in.read();
                this.keyFingerprint = new byte[keyInfoLen - 1];
                in.readFully(this.keyFingerprint);
                this.keyID = this.keyVersion == 4 ? FingerprintUtil.keyIdFromV4Fingerprint(this.keyFingerprint) : FingerprintUtil.keyIdFromV6Fingerprint(this.keyFingerprint);
            }
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP public key encrypted session key packet version encountered: " + this.version);
        }
        this.algorithm = in.read();
        switch (this.algorithm) {
            case 1: 
            case 2: {
                this.data = new byte[1][];
                this.data[0] = new MPInteger(in).getEncoded();
                break;
            }
            case 16: 
            case 20: {
                this.data = new byte[2][];
                this.data[0] = new MPInteger(in).getEncoded();
                this.data[1] = new MPInteger(in).getEncoded();
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                this.data = new byte[1][];
                this.data[0] = Streams.readAll(in);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public PublicKeyEncSessionPacket(long keyID, int algorithm, byte[][] data) {
        super(1);
        this.version = 3;
        this.keyID = keyID;
        this.algorithm = algorithm;
        this.data = new byte[data.length][];
        for (int i = 0; i != data.length; ++i) {
            this.data[i] = Arrays.clone(data[i]);
        }
    }

    public PublicKeyEncSessionPacket(int keyVersion, byte[] keyFingerprint, int algorithm, byte[][] data) {
        super(1);
        this.version = 6;
        this.keyVersion = keyVersion;
        this.keyFingerprint = Arrays.clone(keyFingerprint);
        this.algorithm = algorithm;
        this.data = new byte[data.length][];
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = Arrays.clone(data[i]);
        }
    }

    public static PublicKeyEncSessionPacket createV3PKESKPacket(long keyID, int algorithm, byte[][] data) {
        return new PublicKeyEncSessionPacket(keyID, algorithm, data);
    }

    public static PublicKeyEncSessionPacket createV6PKESKPacket(int keyVersion, byte[] keyFingerprint, int algorithm, byte[][] data) {
        return new PublicKeyEncSessionPacket(keyVersion, keyFingerprint, algorithm, data);
    }

    public int getVersion() {
        return this.version;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getKeyFingerprint() {
        return Arrays.clone(this.keyFingerprint);
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[][] getEncSessionKey() {
        return this.data;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        if (this.version == 3) {
            StreamUtil.writeKeyID(pOut, this.keyID);
        } else if (this.version == 6) {
            pOut.write(this.keyFingerprint.length + 1);
            pOut.write(this.keyVersion);
            pOut.write(this.keyFingerprint);
        }
        pOut.write(this.algorithm);
        for (int i = 0; i != this.data.length; ++i) {
            pOut.write(this.data[i]);
        }
        pOut.close();
        out.writePacket(this.hasNewPacketFormat(), 1, bOut.toByteArray());
    }
}

