/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.Hex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGPSessionKey {
    private final int algorithm;
    private final byte[] sessionKey;

    public PGPSessionKey(int algorithm, byte[] sessionKey) {
        this.algorithm = algorithm;
        this.sessionKey = sessionKey;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        byte[] copy = new byte[this.sessionKey.length];
        System.arraycopy(this.sessionKey, 0, copy, 0, this.sessionKey.length);
        return copy;
    }

    public String toString() {
        return this.algorithm + ":" + this.sessionKey;
    }

    public static PGPSessionKey fromAsciiRepresentation(String ascii) {
        Pattern pattern = Pattern.compile("(\\d{1,3}):([0-9A-Fa-f]+)");
        Matcher matcher = pattern.matcher(ascii);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Provided ascii encoding does not match expected format <algo-num>:<hex-key>");
        }
        String alg = matcher.group(1);
        String hexKey = matcher.group(2);
        return new PGPSessionKey(Integer.parseInt(alg), Hex.decode(hexKey));
    }
}

