/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.activate_deactivate;

import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateAction;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.watch.activate_deactivate.DeActivateWatchRequest;
import com.floragunn.signals.actions.watch.activate_deactivate.DeActivateWatchResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class TransportDeActivateWatchAction
extends HandledTransportAction<DeActivateWatchRequest, DeActivateWatchResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeActivateWatchAction.class);
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportDeActivateWatchAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:watch/activate_deactivate", transportService, actionFilters, DeActivateWatchRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, final DeActivateWatchRequest request, final ActionListener<DeActivateWatchResponse> listener) {
        try (XContentBuilder watchContentBuilder = XContentFactory.jsonBuilder();){
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOOP, RestStatus.UNAUTHORIZED, "Request did not contain user"));
                return;
            }
            final SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOT_FOUND, RestStatus.NOT_FOUND, "No such tenant: " + user.getRequestedTenant()));
                return;
            }
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            Map originalResponseHeaders = threadContext.getResponseHeaders();
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                final UpdateRequest updateRequest = new UpdateRequest(signalsTenant.getConfigIndexName(), signalsTenant.getWatchIdForConfigIndex(request.getWatchId()));
                updateRequest.doc(new Object[]{"active", request.isActivate()});
                updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(){

                    public void onResponse(UpdateResponse response) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got response " + String.valueOf(response) + " for " + String.valueOf(updateRequest));
                        }
                        if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                            SchedulerConfigUpdateAction.send((Client)TransportDeActivateWatchAction.this.client, (String)signalsTenant.getScopedName());
                            listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), response.getVersion(), response.getResult(), RestStatus.OK, null));
                        } else if (response.getResult() == DocWriteResponse.Result.NOOP) {
                            listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), response.getVersion(), response.getResult(), RestStatus.OK, null));
                        } else if (response.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                            listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), response.getVersion(), DocWriteResponse.Result.NOT_FOUND, RestStatus.NOT_FOUND, "No such watch: " + request.getWatchId()));
                        } else {
                            log.error("Unexpected result " + String.valueOf(response) + " in " + String.valueOf(response) + " for " + String.valueOf(updateRequest));
                            listener.onResponse((Object)new DeActivateWatchResponse(request.getWatchId(), response.getVersion(), response.getResult(), RestStatus.INTERNAL_SERVER_ERROR, "Unexpected result " + String.valueOf(response.getResult()) + " in " + String.valueOf(response) + " for " + String.valueOf(updateRequest)));
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

