/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R> Function<T, Optional<R>> lifted(ThrowingFunction<T, R, ?> f) {
        return Objects.requireNonNull(f).lift();
    }

    public static <T, R> Function<T, R> unchecked(ThrowingFunction<T, R, ?> f) {
        return Objects.requireNonNull(f).uncheck();
    }

    public static <T1, R> Function<T1, R> sneaky(ThrowingFunction<? super T1, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply((Object)t);
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    default public <V> ThrowingFunction<V, R, E> compose(ThrowingFunction<? super V, ? extends T, ? extends E> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> ThrowingFunction<T, V, E> andThen(ThrowingFunction<? super R, ? extends V, ? extends E> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public Function<T, Optional<R>> lift() {
        return t -> {
            try {
                return Optional.ofNullable(this.apply(t));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }

    default public Function<T, R> uncheck() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

