/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.searchsupport.meta.Meta;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.indices.SystemIndices;

public class SystemIndexAccess {
    public static final SystemIndexAccess DISALLOWED = new SystemIndexAccess(false, i -> false);
    private final boolean allowed;
    private final Predicate<String> indexNamePredicate;

    SystemIndexAccess(boolean allowed, Predicate<String> indexNamePredicate) {
        this.allowed = allowed;
        this.indexNamePredicate = indexNamePredicate;
    }

    public boolean isNotAllowed() {
        return !this.allowed;
    }

    public boolean isAllowed(Meta.IndexLikeObject index) {
        return this.indexNamePredicate.test(index.name());
    }

    public boolean isAllowed(String index) {
        return this.indexNamePredicate.test(index);
    }

    public static SystemIndexAccess get(IndexNameExpressionResolver indexNameExpressionResolver) {
        SystemIndices.SystemIndexAccessLevel level = indexNameExpressionResolver.getSystemIndexAccessLevel();
        if (level == SystemIndices.SystemIndexAccessLevel.NONE) {
            return DISALLOWED;
        }
        return new SystemIndexAccess(true, i -> indexNameExpressionResolver.getSystemIndexAccessPredicate().test(i));
    }
}

