/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.enterprise.femt.request.mapper.Unscoper;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.util.concurrent.ThreadContext;

class TenantScopedActionListenerWrapper<T extends ActionResponse>
implements ActionListener<T> {
    private static final Logger LOG = LogManager.getLogger(TenantScopedActionListenerWrapper.class);
    private final ActionListener<T> delegate;
    private final Unscoper<T> unscoper;
    private final ThreadContext.StoredContext contextToRestore;
    private final Consumer<T> finalActionForResponse;

    protected TenantScopedActionListenerWrapper(ActionListener<?> delegate, ThreadContext.StoredContext contextToRestore, Unscoper<T> unscoper, Consumer<T> finalActionForUnscopedResponse) {
        this.delegate = Objects.requireNonNull(delegate, "Action listener is required");
        this.unscoper = Objects.requireNonNull(unscoper, "Unscoper is required");
        this.contextToRestore = Objects.requireNonNull(contextToRestore, "Thread context is required");
        this.finalActionForResponse = Objects.requireNonNull(finalActionForUnscopedResponse, "Final action on response is required");
    }

    protected TenantScopedActionListenerWrapper(ActionListener<?> delegate, ThreadContext.StoredContext contextToRestore, Unscoper<T> unscoper) {
        this(delegate, contextToRestore, unscoper, unscopedResponse -> LOG.debug("Nothing to do on response {}.", unscopedResponse));
    }

    public void onResponse(T response) {
        try {
            this.contextToRestore.restore();
            T unscopedResponse = this.unscoper.unscopeResponse(response);
            try {
                this.delegate.onResponse(unscopedResponse);
            }
            finally {
                this.finalActionForResponse.accept(unscopedResponse);
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred while handling {} response", (Object)response.getClass().getName(), (Object)e);
            this.delegate.onFailure(e);
        }
    }

    public void onFailure(Exception e) {
        this.contextToRestore.restore();
        this.delegate.onFailure(e);
    }
}

