/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TransactionSettingsCommitDurability {
    NON_SYNCHRONOUS(0),
    PARTIALLY_SYNCHRONOUS(1),
    FULLY_SYNCHRONOUS(2);

    private final int intValue;

    private TransactionSettingsCommitDurability(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static TransactionSettingsCommitDurability valueOf(int intValue) {
        for (TransactionSettingsCommitDurability v : TransactionSettingsCommitDurability.values()) {
            if (v.intValue != intValue) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static TransactionSettingsCommitDurability forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "nonsynchronous": 
            case "non-synchronous": 
            case "non_synchronous": {
                return NON_SYNCHRONOUS;
            }
            case "partiallysynchronous": 
            case "partially-synchronous": 
            case "partially_synchronous": {
                return PARTIALLY_SYNCHRONOUS;
            }
            case "fullysynchronous": 
            case "fully-synchronous": 
            case "fully_synchronous": {
                return FULLY_SYNCHRONOUS;
            }
        }
        return null;
    }
}

