/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.execute;

import com.floragunn.signals.execution.SimulationMode;
import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ExecuteWatchRequest
extends ActionRequest {
    private String watchId;
    private String watchJson;
    private boolean recordExecution;
    private SimulationMode simulationMode;
    private String goTo;
    private String inputJson;
    private boolean includeAllRuntimeAttributesInResponse;

    public ExecuteWatchRequest() {
    }

    public ExecuteWatchRequest(String watchId, String watchJson, boolean recordExecution, SimulationMode simulationMode, boolean includeAllRuntimeAttributesInResponse) {
        this.watchId = watchId;
        this.watchJson = watchJson;
        this.recordExecution = recordExecution;
        this.simulationMode = simulationMode;
        this.includeAllRuntimeAttributesInResponse = includeAllRuntimeAttributesInResponse;
    }

    public ExecuteWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.watchId = in.readOptionalString();
        this.watchJson = in.readOptionalString();
        this.recordExecution = in.readBoolean();
        this.simulationMode = (SimulationMode)in.readEnum(SimulationMode.class);
        this.goTo = in.readOptionalString();
        this.inputJson = in.readOptionalString();
        this.includeAllRuntimeAttributesInResponse = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.watchId);
        out.writeOptionalString(this.watchJson);
        out.writeBoolean(this.recordExecution);
        out.writeEnum((Enum)this.simulationMode);
        out.writeOptionalString(this.goTo);
        out.writeOptionalString(this.inputJson);
        out.writeBoolean(this.includeAllRuntimeAttributesInResponse);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getWatchId() {
        return this.watchId;
    }

    public void setWatchId(String watchId) {
        this.watchId = watchId;
    }

    public boolean isRecordExecution() {
        return this.recordExecution;
    }

    public void setRecordExecution(boolean recordExecution) {
        this.recordExecution = recordExecution;
    }

    public String getWatchJson() {
        return this.watchJson;
    }

    public void setWatchJson(String watchJson) {
        this.watchJson = watchJson;
    }

    public SimulationMode getSimulationMode() {
        return this.simulationMode;
    }

    public void setSimulationMode(SimulationMode simulationMode) {
        this.simulationMode = simulationMode;
    }

    public String getGoTo() {
        return this.goTo;
    }

    public void setGoTo(String goTo) {
        this.goTo = goTo;
    }

    public String getInputJson() {
        return this.inputJson;
    }

    public void setInputJson(String inputJson) {
        this.inputJson = inputJson;
    }

    public boolean isIncludeAllRuntimeAttributesInResponse() {
        return this.includeAllRuntimeAttributesInResponse;
    }

    public void setIncludeAllRuntimeAttributesInResponse(boolean includeAllRuntimeAttributesInResponse) {
        this.includeAllRuntimeAttributesInResponse = includeAllRuntimeAttributesInResponse;
    }
}

