/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.saml;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.elasticsearch.SpecialPermission;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;

public class StaticMetadataResolver
extends AbstractBatchMetadataResolver {
    private final XMLObject metadata;

    public StaticMetadataResolver(String metadataXml) throws ConfigValidationException {
        try {
            BasicParserPool basicParserPool = new BasicParserPool();
            try {
                basicParserPool.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new RuntimeException(e);
            }
            this.setParserPool((ParserPool)basicParserPool);
            this.setId("static_metadata");
            this.metadata = this.unmarshallMetadata(new ByteArrayInputStream(metadataXml.getBytes(Charsets.UTF_8)));
            if (!this.isValid(this.metadata)) {
                throw new ResolverException("SAML metadata has expired");
            }
        }
        catch (ResolverException e) {
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
        catch (UnmarshallingException e) {
            throw new ConfigValidationException(new ValidationError(null, "Not a valid XML structure").cause((Throwable)e));
        }
    }

    public void initializePrivileged() throws ComponentInitializationException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ComponentInitializationException {
                    StaticMetadataResolver.this.initialize();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof ComponentInitializationException) {
                throw (ComponentInitializationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        try {
            AbstractBatchMetadataResolver.BatchEntityBackingStore backingStore = this.preProcessNewMetadata(this.metadata);
            this.setBackingStore((AbstractMetadataResolver.EntityBackingStore)backingStore);
        }
        catch (FilterException e) {
            throw new ComponentInitializationException((Exception)((Object)e));
        }
    }
}

