/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation.errors;

import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;

public class InvalidExpression
extends ValidationError {
    private final String expression;
    private int column = -1;

    public InvalidExpression(String attribute, String expression) {
        super(attribute, "Invalid expression");
        this.expression = expression;
    }

    @Override
    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.getMessage());
        result.put("value", this.expression);
        if (this.column != -1) {
            result.put("column", this.column);
        }
        if (this.getExpected() != null) {
            result.put("expected", this.getExpectedAsString());
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.getMessage());
        if (this.column != -1) {
            result.append(" at column ").append(this.column);
        }
        if (this.getExpected() != null) {
            result.append("; expected: ").append(this.getExpectedAsString());
        }
        result.append("; expression: ").append(this.expression);
        if (this.getAttribute() != null) {
            result.append("; attribute: ").append(this.getAttribute());
        }
        return result.toString();
    }

    @Override
    public String toValidationErrorsOverviewString() {
        StringBuilder result = new StringBuilder(this.getMessage());
        if (this.column != -1) {
            result.append(" at column ").append(this.column);
        }
        if (this.getExpected() != null) {
            result.append("; expected: ").append(this.getExpectedAsString());
        }
        result.append("; got: ").append(this.expression);
        return result.toString();
    }

    @Override
    public InvalidExpression expected(Object expected) {
        super.expected(expected);
        return this;
    }

    @Override
    public InvalidExpression message(String message) {
        super.message(message);
        return this;
    }

    public InvalidExpression column(int column) {
        this.column = column;
        return this;
    }

    @Override
    protected InvalidExpression clone() {
        return (InvalidExpression)new InvalidExpression(this.getAttribute(), this.expression).expected(this.getExpected()).cause(this.getCause()).docNode(this.getDocNode()).message(this.getMessage());
    }
}

