/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CountAggregation
extends Measurement<CountAggregation> {
    static final String TYPE = "agg";
    private static final OrderedImmutableMap<String, Object> ZERO_COUNT = OrderedImmutableMap.of((Object)"count", (Object)0);
    private static final CountAggregation NOOP = new CountAggregation(0L){

        @Override
        public void increment() {
        }

        @Override
        public CountAggregation getSubCount(String name) {
            return this;
        }

        @Override
        public void addToThis(CountAggregation other) {
        }

        @Override
        public void addToThis(Measurement<?> other) {
        }
    };
    private final AtomicLong count = new AtomicLong();
    private final Map<String, CountAggregation> subCounts;

    public static CountAggregation basic(MetricsLevel level) {
        if (level.basicEnabled()) {
            return new CountAggregation();
        }
        return NOOP;
    }

    public static CountAggregation noop() {
        return NOOP;
    }

    public CountAggregation() {
        this.subCounts = new ConcurrentHashMap<String, CountAggregation>();
    }

    CountAggregation(long count) {
        this.count.set(count);
        this.subCounts = new HashMap<String, CountAggregation>();
    }

    CountAggregation(DocNode docNode) {
        if (docNode.get("count") instanceof Number) {
            this.count.set(((Number)docNode.get("count")).longValue());
        }
        this.subCounts = new HashMap<String, CountAggregation>();
        if (docNode.hasNonNull("parts")) {
            DocNode partsNode = docNode.getAsNode("parts");
            for (String key : partsNode.keySet()) {
                this.subCounts.put(key, new CountAggregation(partsNode.getAsNode(key)));
            }
        }
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public void add(long number) {
        this.count.addAndGet(number);
    }

    public CountAggregation getSubCount(String name) {
        return this.subCounts.computeIfAbsent(name, k -> new CountAggregation());
    }

    public Object toBasicObject() {
        long count = this.count.get();
        if (count == 0L) {
            return ZERO_COUNT;
        }
        if (this.subCounts.size() != 0) {
            return OrderedImmutableMap.of((Object)"count", (Object)count, (Object)"parts", this.subCounts);
        }
        return OrderedImmutableMap.of((Object)"count", (Object)count);
    }

    @Override
    public Measurement<CountAggregation> clone() {
        return new CountAggregation(this.count.get());
    }

    @Override
    public void addToThis(CountAggregation other) {
        this.count.addAndGet(other.count.get());
        if (other.subCounts.size() != 0) {
            for (Map.Entry<String, CountAggregation> entry : other.subCounts.entrySet()) {
                CountAggregation part = this.getSubCount(entry.getKey());
                part.addToThis(entry.getValue());
            }
        }
    }

    @Override
    public void addToThis(Measurement<?> other) {
        if (other instanceof CountAggregation) {
            this.addToThis((CountAggregation)other);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void reset() {
        this.count.set(0L);
        this.subCounts.forEach((k, v) -> v.reset());
    }
}

