/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.indices.IndexMapping;
import java.time.Instant;

public class ConfigVar
implements Document<ConfigVar> {
    static IndexMapping INDEX_MAPPING = new IndexMapping.DynamicIndexMapping(new IndexMapping.Property[]{new IndexMapping.DisabledIndexProperty("value"), new IndexMapping.KeywordProperty("scope"), new IndexMapping.KeywordProperty("updated"), new IndexMapping.ObjectProperty("encrypted", new IndexMapping.Property[]{new IndexMapping.BinaryProperty("value"), new IndexMapping.KeywordProperty("key"), new IndexMapping.KeywordProperty("iv")})});
    private final Object value;
    private final String scope;
    private final String updated;
    private final String encValue;
    private final String encKey;
    private final String encIv;

    private ConfigVar(Object value, String scope, String updated, String encValue, String encKey, String encIv) {
        this.value = value;
        this.scope = scope;
        this.updated = updated;
        this.encValue = encValue;
        this.encKey = encKey;
        this.encIv = encIv;
    }

    public ConfigVar(DocNode docNode) throws ConfigValidationException {
        if (docNode.hasNonNull("value")) {
            this.value = docNode.get("value");
        } else if (docNode.hasNonNull("value_json")) {
            try {
                this.value = DocReader.json().read(docNode.getAsString("value_json"));
            }
            catch (ConfigValidationException e) {
                throw new ConfigValidationException(new ValidationErrors().add("value_json", e));
            }
        } else {
            this.value = null;
        }
        this.scope = docNode.getAsString("scope");
        this.updated = docNode.getAsString("updated");
        if (docNode.hasNonNull("encrypted")) {
            DocNode encrypted = docNode.getAsNode("encrypted");
            this.encValue = encrypted.getAsString("value");
            this.encKey = encrypted.getAsString("key");
            this.encIv = encrypted.getAsString("iv");
            if (this.encKey == null || this.encKey.length() == 0) {
                throw new ConfigValidationException((ValidationError)new MissingAttribute("encrypted.key"));
            }
            if (this.encValue == null || this.encValue.length() == 0) {
                throw new ConfigValidationException((ValidationError)new MissingAttribute("encrypted.value"));
            }
        } else {
            this.encValue = null;
            this.encKey = null;
            this.encIv = null;
        }
        if (this.value == null && this.encValue == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("value"));
        }
    }

    public ConfigVar updatedNow() {
        return new ConfigVar(this.value, this.scope, Instant.now().toString(), this.encValue, this.encKey, this.encIv);
    }

    public Object toBasicObject() {
        if (this.encValue != null) {
            return ImmutableMap.ofNonNull((Object)"encrypted", (Object)ImmutableMap.ofNonNull((Object)"value", (Object)this.encValue, (Object)"key", (Object)this.encKey, (Object)"iv", (Object)this.encIv), (Object)"scope", (Object)this.scope, (Object)"updated", (Object)this.updated);
        }
        return ImmutableMap.ofNonNull((Object)"value", (Object)this.value, (Object)"scope", (Object)this.scope, (Object)"updated", (Object)this.updated);
    }

    public Object toBasicObjectForIndex() {
        if (this.encValue != null) {
            return ImmutableMap.ofNonNull((Object)"encrypted", (Object)ImmutableMap.ofNonNull((Object)"value", (Object)this.encValue, (Object)"key", (Object)this.encKey, (Object)"iv", (Object)this.encIv), (Object)"scope", (Object)this.scope, (Object)"updated", (Object)this.updated);
        }
        return ImmutableMap.ofNonNull((Object)"value", (Object)DocWriter.json().writeAsString(this.value), (Object)"scope", (Object)this.scope, (Object)"updated", (Object)this.updated);
    }

    public Object getValue() {
        return this.value;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUpdated() {
        return this.updated;
    }

    public String getEncValue() {
        return this.encValue;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public String getEncIv() {
        return this.encIv;
    }
}

