"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_PRIVATE_TENANT_NAME = exports.UI_GLOBAL_TENANT_NAME = exports.PRIVATE_TENANT_NAME = exports.GLOBAL_TENANT_NAME = void 0;
exports.tenantNameToUiTenantName = tenantNameToUiTenantName;
exports.uiTenantNameToTenantName = uiTenantNameToTenantName;
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const UI_GLOBAL_TENANT_NAME = exports.UI_GLOBAL_TENANT_NAME = 'Global';
const UI_PRIVATE_TENANT_NAME = exports.UI_PRIVATE_TENANT_NAME = 'Private';
const GLOBAL_TENANT_NAME = exports.GLOBAL_TENANT_NAME = '';
const PRIVATE_TENANT_NAME = exports.PRIVATE_TENANT_NAME = '__user__';
function tenantNameToUiTenantName(name) {
  if (!name) return UI_GLOBAL_TENANT_NAME;
  const map = new Map([[GLOBAL_TENANT_NAME, UI_GLOBAL_TENANT_NAME], [PRIVATE_TENANT_NAME, UI_PRIVATE_TENANT_NAME]]);
  return map.get(name) || name;
}
function uiTenantNameToTenantName(name) {
  const map = new Map([[UI_GLOBAL_TENANT_NAME, GLOBAL_TENANT_NAME], [UI_PRIVATE_TENANT_NAME, PRIVATE_TENANT_NAME]]);
  const tenantName = map.get(name);
  return tenantName === GLOBAL_TENANT_NAME ? tenantName : tenantName || name;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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