"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Multitenancy = void 0;
var _tenants_migration_service = require("./tenants_migration_service");
var _routes = require("./routes");
var _multitenancy_lifecycle = require("./multitenancy_lifecycle");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2020 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class Multitenancy {
  constructor(coreContext) {
    this.coreContext = coreContext;
    this.logger = coreContext.logger.get('searchguard-multitenancy');
    this.tenantsMigration = new _tenants_migration_service.TenantsMigrationService(coreContext);
  }
  async setup({
    kibanaRouter,
    authManager,
    kerberos,
    kibanaCore,
    sessionStorageFactory,
    pluginDependencies,
    configService,
    searchGuardBackend,
    spacesService,
    tenantService,
    savedObjects,
    elasticsearch
  }) {
    this.logger.debug('Setup app');
    const requestHeadersWhitelist = configService.get('elasticsearch.requestHeadersWhitelist');
    if (!requestHeadersWhitelist.includes('sgtenant')) {
      throw new Error('No tenant header found in whitelist. Please add sgtenant to elasticsearch.requestHeadersWhitelist in kibana.yml');
    }
    try {
      this.tenantsMigration.setup({
        configService,
        savedObjects,
        esClient: elasticsearch.client,
        kibanaRouter,
        searchGuardBackend
      });
      const multitenancyLifecycle = new _multitenancy_lifecycle.MultitenancyLifecycle({
        authManager,
        kerberos,
        searchGuardBackend,
        configService,
        sessionStorageFactory,
        logger: this.logger,
        clusterClient: elasticsearch.client,
        pluginDependencies,
        spacesService,
        tenantService
      });
      kibanaCore.http.registerOnPreAuth(multitenancyLifecycle.onPreAuth);
      (0, _routes.defineMultitenancyRoutes)({
        router: kibanaRouter,
        searchGuardBackend,
        config: configService,
        sessionStorageFactory,
        logger: this.logger,
        clusterClient: elasticsearch.client,
        tenantService
      });
    } catch (error) {
      this.logger.error(`setup: ${error.toString()} ${error.stack}`);
    }
  }
  async start({
    core,
    searchGuardBackend,
    configService
  }) {
    this.logger.debug('Start app');
    const esClient = core.elasticsearch.client;
    const savedObjects = core.savedObjects;
    try {
      await this.tenantsMigration.start({
        esClient,
        searchGuardBackend,
        configService,
        savedObjects
      });
    } catch (error) {
      this.logger.error(`start: ${error.toString()} ${error.stack}`);
    }
  }
}
exports.Multitenancy = Multitenancy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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