"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTenantInfo = void 0;
exports.getTenantInfoRoute = getTenantInfoRoute;
var _constants = require("../../../utils/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getTenantInfo = ({
  searchGuardBackend,
  logger
}) => async (context, request, response) => {
  try {
    return response.ok({
      body: await searchGuardBackend.getTenantInfoWithInternalUser()
    });
  } catch (error) {
    logger.error(`getTenantInfo: ${error.stack}`);
    return response.internalError({
      body: error
    });
  }
};
exports.getTenantInfo = getTenantInfo;
function getTenantInfoRoute({
  router,
  searchGuardBackend,
  logger
}) {
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/tenantinfo`,
    validate: false,
    options: {
      authRequired: true
    }
  }, getTenantInfo({
    searchGuardBackend,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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