"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "defineMigrateRoutes", {
  enumerable: true,
  get: function () {
    return _migrate.migrateTenantsRoute;
  }
});
exports.defineMultitenancyRoutes = defineMultitenancyRoutes;
var _multitenancy = require("./multitenancy");
var _get_tenant_info = require("./get_tenant_info");
var _migrate = require("./migrate");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function defineMultitenancyRoutes({
  router,
  searchGuardBackend,
  config,
  sessionStorageFactory,
  logger,
  clusterClient,
  tenantService
}) {
  (0, _multitenancy.multitenancyRoutes)({
    router,
    searchGuardBackend,
    config,
    sessionStorageFactory,
    logger,
    clusterClient,
    tenantService
  });
  (0, _get_tenant_info.getTenantInfoRoute)({
    searchGuardBackend,
    logger,
    router
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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