"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateTenants = migrateTenants;
exports.migrateTenantsRoute = migrateTenantsRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../utils/constants");
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function migrateTenants({
  searchGuardBackend,
  KibanaMigrator,
  migratorDeps: {
    client,
    kibanaConfig,
    typeRegistry,
    logger,
    kibanaVersion,
    soMigrationsConfig
  }
}) {
  return async function (context, request, response) {
    try {
      const {
        tenantIndex
      } = request.params;
      let body;
      if (!tenantIndex) {
        return response.badRequest({
          body: new Error('Tenant index name is required as the request parameter.')
        });
      }
      let tenantIndices = await searchGuardBackend.getTenantInfoWithInternalUser();
      tenantIndices = !tenantIndices || typeof tenantIndices !== 'object' ? [] : Object.keys(tenantIndices);
      if (!tenantIndices.length) {
        return response.customError({
          statusCode: 503,
          body: new Error('No tenant indices have been found. Migration is not triggered.')
        });
      }
      if (tenantIndex === '_all') {
        body = await Promise.all(tenantIndices.map(index => {
          const kibanaMigrator = new KibanaMigrator({
            client,
            kibanaConfig: {
              ...kibanaConfig,
              index
            },
            typeRegistry,
            logger,
            kibanaVersion,
            soMigrationsConfig
          });
          kibanaMigrator.prepareMigrations();
          return kibanaMigrator.runMigrations({
            rerun: true
          });
        }));
        return response.ok({
          body
        });
      }
      const indexToMigrate = tenantIndices.find(index => index === tenantIndex);
      if (!indexToMigrate) {
        return response.customError({
          statusCode: 503,
          body: new Error(`The tenant's index "${tenantIndex}" has not been found. Check if the index name is correct.`)
        });
      }
      const kibanaMigrator = new KibanaMigrator({
        client,
        kibanaConfig: {
          ...kibanaConfig,
          index: indexToMigrate
        },
        typeRegistry,
        logger,
        kibanaVersion,
        soMigrationsConfig
      });
      kibanaMigrator.prepareMigrations();
      body = await kibanaMigrator.runMigrations({
        rerun: true
      });
      return response.ok({
        body
      });
    } catch (error) {
      logger.error(`migrateRoute - ${error}: ${error.stack}`);
      return response.internalError({
        body: error
      });
    }
  };
}
function migrateTenantsRoute({
  kibanaRouter,
  searchGuardBackend,
  migratorDeps,
  KibanaMigrator
}) {
  const options = {
    path: `${_constants.API_ROOT}/multitenancy/migrate/{tenantIndex}`,
    validate: {
      params: _configSchema.schema.object({
        tenantIndex: _configSchema.schema.string()
      })
    }
  };
  kibanaRouter.post(options, migrateTenants({
    searchGuardBackend,
    migratorDeps,
    KibanaMigrator
  }));
  kibanaRouter.get(options, migrateTenants({
    searchGuardBackend,
    migratorDeps,
    KibanaMigrator
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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