"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.multitenancyRoutes = multitenancyRoutes;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _router = require("../../../../../../src/core/server/http/router");
var _constants = require("../../../utils/constants");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2016 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

function multitenancyRoutes({
  router,
  searchGuardBackend,
  config,
  sessionStorageFactory,
  logger,
  tenantService
}) {
  const debugEnabled = config.get('searchguard.multitenancy.debug');
  router.post({
    path: `${_constants.API_ROOT}/multitenancy/tenant`,
    validate: {
      body: _configSchema.schema.object({
        tenant: _configSchema.schema.string(),
        username: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const selectedTenant = request.body.tenant;
      const cookie = (await sessionStorageFactory.asScoped(request).get()) || {};
      cookie.tenant = selectedTenant;
      sessionStorageFactory.asScoped(request).set(cookie);
      if (debugEnabled) {
        logger.info(`tenant_POST: ${selectedTenant}`);
      }
      const rawRequest = (0, _router.ensureRawRequest)(request);
      (0, _lodash.assign)(rawRequest.headers, {
        sgtenant: selectedTenant || ''
      });
      await tenantService.createIndexForTenant({
        request,
        selectedTenant
      });
      return response.ok({
        body: selectedTenant
      });
    } catch (error) {
      return response.internalError({
        body: error
      });
    }
  });
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/tenant`,
    validate: false
  }, async (context, request, response) => {
    let selectedTenant = undefined;
    const cookie = await sessionStorageFactory.asScoped(request).get();
    if (cookie) {
      selectedTenant = cookie.tenant;
    }
    if (debugEnabled) {
      logger.info(`tenant_GET: ${selectedTenant}`);
    }
    return response.ok({
      body: selectedTenant
    });
  });
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/info`,
    validate: false
  }, async (context, request, response) => {
    const mtinfo = await searchGuardBackend.multitenancyinfo(request.headers);
    return response.ok({
      body: mtinfo
    });
  });
} //end module
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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