"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesService = exports.DEFAULT_SPACE_ID = void 0;
exports.getDefaultSpaceDoc = getDefaultSpaceDoc;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const DEFAULT_SPACE_ID = exports.DEFAULT_SPACE_ID = 'space:default';

// ATTENTION! If either Saved Objects migration or integration with spaces doesn't work,
// check the space document structure in your Kibana version. Maybe it changed.
function getDefaultSpaceDoc(kibanaVersion) {
  return {
    space: {
      name: 'Default',
      description: 'This is your default space!',
      disabledFeatures: [],
      color: '#00bfb3',
      _reserved: true
    },
    type: 'space',
    references: [],
    migrationVersion: {
      space: '6.6.0'
    },
    coreMigrationVersion: kibanaVersion,
    updated_at: new Date().toISOString()
  };
}
class SpacesService {
  constructor({
    kibanaVersion,
    tenantService
  }) {
    (0, _defineProperty2.default)(this, "createDefaultSpace", async ({
      request,
      selectedTenant = ''
    } = {}) => {
      const spaceExists = await this.tenantService.docExists({
        request,
        indexName: this.tenantService.aliasName,
        docId: DEFAULT_SPACE_ID
      });
      if (!spaceExists) {
        return this.tenantService.createDoc({
          request,
          tenantName: selectedTenant,
          versionIndexName: this.tenantService.versionIndexName,
          docId: DEFAULT_SPACE_ID,
          docBody: getDefaultSpaceDoc(this.kibanaVersion)
        });
      }
    });
    this.kibanaVersion = kibanaVersion;
    this.tenantService = tenantService;
  }
}
exports.SpacesService = SpacesService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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