"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _AuthType = _interopRequireDefault(require("../AuthType"));
var _missing_role_error = _interopRequireDefault(require("../../errors/missing_role_error"));
var _routes = require("./routes");
var _constants = require("../../../../../utils/constants");
var _path = _interopRequireDefault(require("path"));
var _AuthManager = require("../../AuthManager");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2018 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class BasicAuth extends _AuthType.default {
  constructor({
    searchGuardBackend,
    kibanaCore,
    config,
    logger,
    sessionStorageFactory,
    pluginDependencies,
    spacesService
  }) {
    super({
      searchGuardBackend,
      kibanaCore,
      config,
      logger,
      sessionStorageFactory,
      pluginDependencies,
      spacesService
    });

    /**
     * The authType is saved in the auth cookie for later reference
     * @type {string}
     */
    this.type = _AuthManager.AUTH_TYPE_NAMES.BASIC;

    /**
     * The name of the authorization header to be used
     * @type {string}
     */
    this.authHeaderName = 'authorization';

    /**
     * Allow anonymous access?
     * @type {boolean}
     */
    this.anonymousAuthEnabled = this.config.get('searchguard.auth.anonymous_auth_enabled');
  }
  async getRedirectTargetForUnauthenticated(request, error = null, isAJAX = false) {
    const url = new URL(request.url.href);
    let appRoot = _path.default.posix.join(this.basePath, _constants.APP_ROOT);
    if (!isAJAX) {
      url.searchParams.set('nextUrl', this.getNextUrl(request));
      // Delete sg_tenant because we have it already as a param in the nextUrl
      url.searchParams.delete('sg_tenant');
    }
    if (error && error instanceof _missing_role_error.default) {
      url.searchParams.set('type', 'missingRole');
      url.pathname = _path.default.posix.join(appRoot, '/customerror');
    } else {
      url.pathname = _path.default.posix.join(appRoot, '/login');
    }
    return url.pathname + url.search + url.hash;
  }
  setupRoutes() {
    (0, _routes.defineRoutes)({
      authInstance: this,
      searchGuardBackend: this.searchGuardBackend,
      kibanaCore: this.kibanaCore,
      kibanaConfig: this.config,
      sessionStorageFactory: this.sessionStorageFactory,
      logger: this.logger
    });
  }
}
exports.default = BasicAuth;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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