"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleKibanaConfig = handleKibanaConfig;
exports.kibanaConfigRoute = kibanaConfigRoute;
var _lodash = require("lodash");
var _constants = require("../../../utils/constants");
/* eslint-disable @kbn/eslint/require-license-header */

function handleKibanaConfig({
  config,
  logger
}) {
  return async function (context, request, response) {
    try {
      let kibanaConfig = {};

      // ATTENTION! We must be careful to not expose sensitive config to UI,
      // e.g. elasticsearch password, cookie password, TLS certificates, headers, etc.
      // That is why we explicitly serve only a portion of the config.
      if (typeof config === 'object' && config !== null) {
        kibanaConfig = {
          searchguard: (0, _lodash.pick)(config.searchguard || {}, ['enabled', 'sgVersion']),
          elasticsearch: (0, _lodash.pick)(config.elasticsearch || {}, ['username']),
          kibana: (0, _lodash.pick)(config.kibana || {}, ['index'])
        };
        config.searchguard.readonly_mode = config.searchguard.readonly_mode || {};
        kibanaConfig.searchguard.readonly_mode = (0, _lodash.pick)(config.searchguard.readonly_mode, ['roles']);
        config.searchguard.auth = config.searchguard.auth || {};
        kibanaConfig.searchguard.auth = (0, _lodash.pick)(config.searchguard.auth, ['type']);

        // At the moment we use this to decide whether or not to display the logout button
        kibanaConfig.uiHelpers = {};
        if (context.searchGuard.authManager) {
          kibanaConfig.uiHelpers.hasAuthCookie = (await context.searchGuard.authManager.getAuthHeader(request)) === false ? false : true;
        }
        config.searchguard.multitenancy = config.searchguard.multitenancy || {};
        kibanaConfig.searchguard.multitenancy = {
          ...(0, _lodash.pick)(config.searchguard.multitenancy, ['enable_filter', 'show_roles']),
          tenants: (0, _lodash.pick)(config.searchguard.multitenancy.tenants, ['enable_private', 'enable_global', 'preferred'])
        };
        config.searchguard.accountinfo = config.searchguard.accountinfo || {};
        kibanaConfig.searchguard.accountinfo = (0, _lodash.pick)(config.searchguard.accountinfo, ['enabled']);
      }
      logger.debug('Serve the Kibana config:', JSON.stringify(kibanaConfig, null, 2));
      return response.ok({
        body: kibanaConfig
      });
    } catch (error) {
      logger.error(error);
      return response.internalError({
        body: error
      });
    }
  };
}
function kibanaConfigRoute({
  router,
  config,
  logger
}) {
  const options = {
    path: `${_constants.API_ROOT}/${'searchguard'}/kibana_config`,
    validate: false
  };
  router.get(options, handleKibanaConfig({
    config,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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