"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alwaysPresentCertificateWarnText = exports.allowClientCertificatesNeededForSSLCertificateErrorText = void 0;
exports.checkCookieConfig = checkCookieConfig;
exports.checkDoNotFailOnForbidden = checkDoNotFailOnForbidden;
exports.checkTLSConfig = checkTLSConfig;
exports.checkXPackSecurityDisabled = checkXPackSecurityDisabled;
exports.xPackSecurityErrorText = exports.failedCheckDoNotFailOnForbiddenText = exports.doNotFailOnForbiddenText = exports.defaultCookiePasswordWarnText = exports.cookieSecureFalseWarnText = void 0;
var _default_config = require("../../default_config");
/* eslint-disable @kbn/eslint/require-license-header */

const xPackSecurityErrorText = exports.xPackSecurityErrorText = 'X-Pack Security needs to be disabled for Search Guard to work properly. Please set "xpack.security.enabled" to false in your kibana.yml';
const doNotFailOnForbiddenText = exports.doNotFailOnForbiddenText = '"Do not fail on forbidden" is not enabled. Please refer to the documentation: https://docs.search-guard.com/latest/kibana-plugin-installation#configuring-elasticsearch-enable-do-not-fail-on-forbidden';
const failedCheckDoNotFailOnForbiddenText = exports.failedCheckDoNotFailOnForbiddenText = 'Failed to verify the "not_fail_on_forbidden_enabled" option.';
const allowClientCertificatesNeededForSSLCertificateErrorText = exports.allowClientCertificatesNeededForSSLCertificateErrorText = '"elasticsearch.ssl.certificate" can not be used without setting "searchguard.allow_client_certificates" to "true" in kibana.yml. Please refer to the documentation for more information about the implications of doing so: https://docs.search-guard.com/latest/kibana-plugin-installation#client-certificates-elasticsearchsslcertificate';
const alwaysPresentCertificateWarnText = exports.alwaysPresentCertificateWarnText = "'elasticsearch.ssl.alwaysPresentCertificate' may lead to requests being executed as the user attached to the certificate configured in 'elasticsearch.ssl.certificate'.";
const defaultCookiePasswordWarnText = exports.defaultCookiePasswordWarnText = "Default cookie password detected, please set a password in kibana.yml by setting 'searchguard.cookie.password' (min. 32 characters).";
const cookieSecureFalseWarnText = exports.cookieSecureFalseWarnText = "'searchguard.cookie.secure' is set to false, cookies are transmitted over unsecure HTTP connection. Consider using HTTPS and set this key to 'true'";
function checkXPackSecurityDisabled({
  pluginDependencies,
  logger
}) {
  if (pluginDependencies.security) {
    logger.error(xPackSecurityErrorText);
    throw new Error(xPackSecurityErrorText);
  }
}
async function checkDoNotFailOnForbidden({
  searchGuardBackend,
  logger
}) {
  try {
    const response = await searchGuardBackend.getKibanaInfoWithInternalUser();
    if (response && response.not_fail_on_forbidden_enabled !== true) {
      logger.warn(doNotFailOnForbiddenText);
    }
  } catch (error) {
    logger.error(`${failedCheckDoNotFailOnForbiddenText} ${error.toString()}`);
  }
}
function checkTLSConfig({
  configService,
  logger
}) {
  const sslConfig = configService.get('elasticsearch.ssl', {});
  if (typeof sslConfig.certificate !== 'undefined' && sslConfig.certificate !== false) {
    if (configService.get('searchguard.allow_client_certificates') !== true) {
      logger.error(allowClientCertificatesNeededForSSLCertificateErrorText);
      throw new Error(allowClientCertificatesNeededForSSLCertificateErrorText);
    }
    if (sslConfig.alwaysPresentCertificate === true) {
      // Client certificates allowed, but we still want to warn if alwaysPresentCertificate is true.
      logger.warn(alwaysPresentCertificateWarnText);
    }
  }
}
function checkCookieConfig({
  configService,
  logger
}) {
  if (configService.get('searchguard.cookie.password') === _default_config.DEFAULT_CONFIG.searchguard.cookie.password) {
    logger.warn(defaultCookiePasswordWarnText);
  }
  if (configService.get('searchguard.cookie.secure') !== true) {
    logger.warn(cookieSecureFalseWarnText);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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