"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extendSecurityCookieOptions = extendSecurityCookieOptions;
exports.getSecurityCookieOptions = getSecurityCookieOptions;
var _statehood = _interopRequireDefault(require("@hapi/statehood"));
/* eslint-disable @kbn/eslint/require-license-header */

function getSecurityCookieOptions(configService) {
  const options = {
    encryptionKey: configService.get('searchguard.cookie.password'),
    name: configService.get('searchguard.cookie.name'),
    isSecure: configService.get('searchguard.cookie.secure'),
    // This cookie validation is taken care of by the AuthType.
    // We can't omit this though, because Kibana seems to
    // wrap it somehow
    validate: () => {
      return {
        isValid: true
      };
    },
    clearInvalid: true,
    ttl: configService.get('searchguard.cookie.ttl'),
    sameSite: configService.get('searchguard.cookie.isSameSite')
  };
  if (configService.get('searchguard.cookie.domain')) {
    options.domain = configService.get('searchguard.cookie.domain');
  }
  return options;
}
function extendSecurityCookieOptions(options) {
  const {
    domain,
    ttl
  } = options;
  // https://github.com/hapijs/statehood/blob/master/lib/index.js#L442
  const origPrepareValue = _statehood.default.prepareValue;
  _statehood.default.prepareValue = function (name, value, origOptions) {
    if (name === options.name) {
      origOptions.domain = domain;
      // Converting 0 to null for backward compatibility.
      // Statehood handles 0 "correctly" and sets the ttl to 0ms as opposed to
      // hapi-auth-cookie, which for 0 sets the ttl to browser session.
      // However, setting ttl to 0 milliseconds would render the cookie invalid immediately
      // https://github.com/hapijs/cookie/blob/v9.0.0/lib/index.js#L110
      origOptions.ttl = ttl === 0 ? null : ttl;
    }
    return origPrepareValue(name, value, origOptions);
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc3RhdGVob29kIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJnZXRTZWN1cml0eUNvb2tpZU9wdGlvbnMiLCJjb25maWdTZXJ2aWNlIiwib3B0aW9ucyIsImVuY3J5cHRpb25LZXkiLCJnZXQiLCJuYW1lIiwiaXNTZWN1cmUiLCJ2YWxpZGF0ZSIsImlzVmFsaWQiLCJjbGVhckludmFsaWQiLCJ0dGwiLCJzYW1lU2l0ZSIsImRvbWFpbiIsImV4dGVuZFNlY3VyaXR5Q29va2llT3B0aW9ucyIsIm9yaWdQcmVwYXJlVmFsdWUiLCJTdGF0ZWhvb2QiLCJwcmVwYXJlVmFsdWUiLCJ2YWx1ZSIsIm9yaWdPcHRpb25zIl0sInNvdXJjZXMiOlsic2VjdXJpdHlfY29va2llLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIEBrYm4vZXNsaW50L3JlcXVpcmUtbGljZW5zZS1oZWFkZXIgKi9cbmltcG9ydCBTdGF0ZWhvb2QgZnJvbSAnQGhhcGkvc3RhdGVob29kJztcblxuZXhwb3J0IGZ1bmN0aW9uIGdldFNlY3VyaXR5Q29va2llT3B0aW9ucyhjb25maWdTZXJ2aWNlKSB7XG4gIGNvbnN0IG9wdGlvbnMgPSB7XG4gICAgZW5jcnlwdGlvbktleTogY29uZmlnU2VydmljZS5nZXQoJ3NlYXJjaGd1YXJkLmNvb2tpZS5wYXNzd29yZCcpLFxuICAgIG5hbWU6IGNvbmZpZ1NlcnZpY2UuZ2V0KCdzZWFyY2hndWFyZC5jb29raWUubmFtZScpLFxuICAgIGlzU2VjdXJlOiBjb25maWdTZXJ2aWNlLmdldCgnc2VhcmNoZ3VhcmQuY29va2llLnNlY3VyZScpLFxuICAgIC8vIFRoaXMgY29va2llIHZhbGlkYXRpb24gaXMgdGFrZW4gY2FyZSBvZiBieSB0aGUgQXV0aFR5cGUuXG4gICAgLy8gV2UgY2FuJ3Qgb21pdCB0aGlzIHRob3VnaCwgYmVjYXVzZSBLaWJhbmEgc2VlbXMgdG9cbiAgICAvLyB3cmFwIGl0IHNvbWVob3dcbiAgICB2YWxpZGF0ZTogKCkgPT4ge1xuICAgICAgcmV0dXJuIHsgaXNWYWxpZDogdHJ1ZSB9O1xuICAgIH0sXG4gICAgY2xlYXJJbnZhbGlkOiB0cnVlLFxuICAgIHR0bDogY29uZmlnU2VydmljZS5nZXQoJ3NlYXJjaGd1YXJkLmNvb2tpZS50dGwnKSxcbiAgICBzYW1lU2l0ZTogY29uZmlnU2VydmljZS5nZXQoJ3NlYXJjaGd1YXJkLmNvb2tpZS5pc1NhbWVTaXRlJyksXG4gIH07XG5cbiAgaWYgKGNvbmZpZ1NlcnZpY2UuZ2V0KCdzZWFyY2hndWFyZC5jb29raWUuZG9tYWluJykpIHtcbiAgICBvcHRpb25zLmRvbWFpbiA9IGNvbmZpZ1NlcnZpY2UuZ2V0KCdzZWFyY2hndWFyZC5jb29raWUuZG9tYWluJyk7XG4gIH1cblxuICByZXR1cm4gb3B0aW9ucztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGV4dGVuZFNlY3VyaXR5Q29va2llT3B0aW9ucyhvcHRpb25zKSB7XG4gIGNvbnN0IHsgZG9tYWluLCB0dGwgfSA9IG9wdGlvbnM7XG4gIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9oYXBpanMvc3RhdGVob29kL2Jsb2IvbWFzdGVyL2xpYi9pbmRleC5qcyNMNDQyXG4gIGNvbnN0IG9yaWdQcmVwYXJlVmFsdWUgPSBTdGF0ZWhvb2QucHJlcGFyZVZhbHVlO1xuXG4gIFN0YXRlaG9vZC5wcmVwYXJlVmFsdWUgPSBmdW5jdGlvbiAobmFtZSwgdmFsdWUsIG9yaWdPcHRpb25zKSB7XG4gICAgaWYgKG5hbWUgPT09IG9wdGlvbnMubmFtZSkge1xuICAgICAgb3JpZ09wdGlvbnMuZG9tYWluID0gZG9tYWluO1xuICAgICAgLy8gQ29udmVydGluZyAwIHRvIG51bGwgZm9yIGJhY2t3YXJkIGNvbXBhdGliaWxpdHkuXG4gICAgICAvLyBTdGF0ZWhvb2QgaGFuZGxlcyAwIFwiY29ycmVjdGx5XCIgYW5kIHNldHMgdGhlIHR0bCB0byAwbXMgYXMgb3Bwb3NlZCB0b1xuICAgICAgLy8gaGFwaS1hdXRoLWNvb2tpZSwgd2hpY2ggZm9yIDAgc2V0cyB0aGUgdHRsIHRvIGJyb3dzZXIgc2Vzc2lvbi5cbiAgICAgIC8vIEhvd2V2ZXIsIHNldHRpbmcgdHRsIHRvIDAgbWlsbGlzZWNvbmRzIHdvdWxkIHJlbmRlciB0aGUgY29va2llIGludmFsaWQgaW1tZWRpYXRlbHlcbiAgICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9oYXBpanMvY29va2llL2Jsb2IvdjkuMC4wL2xpYi9pbmRleC5qcyNMMTEwXG4gICAgICBvcmlnT3B0aW9ucy50dGwgPSB0dGwgPT09IDAgPyBudWxsIDogdHRsO1xuICAgIH1cblxuICAgIHJldHVybiBvcmlnUHJlcGFyZVZhbHVlKG5hbWUsIHZhbHVlLCBvcmlnT3B0aW9ucyk7XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQ0EsSUFBQUEsVUFBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBREE7O0FBR08sU0FBU0Msd0JBQXdCQSxDQUFDQyxhQUFhLEVBQUU7RUFDdEQsTUFBTUMsT0FBTyxHQUFHO0lBQ2RDLGFBQWEsRUFBRUYsYUFBYSxDQUFDRyxHQUFHLENBQUMsNkJBQTZCLENBQUM7SUFDL0RDLElBQUksRUFBRUosYUFBYSxDQUFDRyxHQUFHLENBQUMseUJBQXlCLENBQUM7SUFDbERFLFFBQVEsRUFBRUwsYUFBYSxDQUFDRyxHQUFHLENBQUMsMkJBQTJCLENBQUM7SUFDeEQ7SUFDQTtJQUNBO0lBQ0FHLFFBQVEsRUFBRUEsQ0FBQSxLQUFNO01BQ2QsT0FBTztRQUFFQyxPQUFPLEVBQUU7TUFBSyxDQUFDO0lBQzFCLENBQUM7SUFDREMsWUFBWSxFQUFFLElBQUk7SUFDbEJDLEdBQUcsRUFBRVQsYUFBYSxDQUFDRyxHQUFHLENBQUMsd0JBQXdCLENBQUM7SUFDaERPLFFBQVEsRUFBRVYsYUFBYSxDQUFDRyxHQUFHLENBQUMsK0JBQStCO0VBQzdELENBQUM7RUFFRCxJQUFJSCxhQUFhLENBQUNHLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxFQUFFO0lBQ2xERixPQUFPLENBQUNVLE1BQU0sR0FBR1gsYUFBYSxDQUFDRyxHQUFHLENBQUMsMkJBQTJCLENBQUM7RUFDakU7RUFFQSxPQUFPRixPQUFPO0FBQ2hCO0FBRU8sU0FBU1csMkJBQTJCQSxDQUFDWCxPQUFPLEVBQUU7RUFDbkQsTUFBTTtJQUFFVSxNQUFNO0lBQUVGO0VBQUksQ0FBQyxHQUFHUixPQUFPO0VBQy9CO0VBQ0EsTUFBTVksZ0JBQWdCLEdBQUdDLGtCQUFTLENBQUNDLFlBQVk7RUFFL0NELGtCQUFTLENBQUNDLFlBQVksR0FBRyxVQUFVWCxJQUFJLEVBQUVZLEtBQUssRUFBRUMsV0FBVyxFQUFFO0lBQzNELElBQUliLElBQUksS0FBS0gsT0FBTyxDQUFDRyxJQUFJLEVBQUU7TUFDekJhLFdBQVcsQ0FBQ04sTUFBTSxHQUFHQSxNQUFNO01BQzNCO01BQ0E7TUFDQTtNQUNBO01BQ0E7TUFDQU0sV0FBVyxDQUFDUixHQUFHLEdBQUdBLEdBQUcsS0FBSyxDQUFDLEdBQUcsSUFBSSxHQUFHQSxHQUFHO0lBQzFDO0lBRUEsT0FBT0ksZ0JBQWdCLENBQUNULElBQUksRUFBRVksS0FBSyxFQUFFQyxXQUFXLENBQUM7RUFDbkQsQ0FBQztBQUNIIiwiaWdub3JlTGlzdCI6W119