"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _router = require("../../../../../../src/core/server/http/router");
/* eslint-disable @kbn/eslint/require-license-header */

/**
 *    Copyright 2019 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

function _default(kibanaCore) {
  kibanaCore.http.registerOnPreAuth(async function (request, response, toolkit) {
    request = (0, _router.ensureRawRequest)(request);
    request.headers['x-forwarded-for'] = (request.headers['x-forwarded-for'] ? request.headers['x-forwarded-for'] + ',' : '') + request.info.remoteAddress;
    request.headers['x-forwarded-port'] = request.headers['x-forwarded-port'] || request.info.remotePort;
    request.headers['x-forwarded-proto'] = request.headers['x-forwarded-proto'] || request.server.info.protocol;
    request.headers['x-forwarded-host'] = request.headers['x-forwarded-host'] || request.info.host;
    return toolkit.next();
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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