"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAccount = void 0;
exports.createAccountRoute = createAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const createAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      body = {},
      params: {
        id,
        type
      }
    } = request;
    const path = `/_signals/account/${encodeURIComponent(type)}/${encodeURIComponent(id)}`;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'put',
      path,
      body
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`createAccount: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.createAccount = createAccount;
function createAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      }),
      body: _configSchema.schema.object({
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, createAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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