"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAccount = void 0;
exports.deleteAccountRoute = deleteAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const deleteAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      type
    } = request.params;
    const path = `/_signals/account/${type}/${encodeURIComponent(id)}`;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'delete',
      path
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`deleteAccount: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.deleteAccount = deleteAccount;
function deleteAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, deleteAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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