"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccount = void 0;
exports.getAccountRoute = getAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _helpers = require("../../lib/helpers");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      type
    } = request.params;
    const path = `/_signals/account/${type}/${encodeURIComponent(id)}`;
    const {
      body: {
        _source,
        _id
      }
    } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'get',
      path
    });
    return response.ok({
      body: {
        ok: true,
        resp: {
          ..._source,
          _id: (0, _helpers.getId)(_id)
        }
      }
    });
  } catch (err) {
    if (err.statusCode !== 404) {
      logger.error(`getAccount: ${err.stack}`);
    }
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getAccount = getAccount;
function getAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, getAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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