"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAlert = void 0;
exports.deleteAlertRoute = deleteAlertRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const deleteAlert = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      index
    } = request.params;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.delete({
      refresh: true,
      type: _constants.INDEX.ALERT_DOC_TYPE,
      index,
      id: id.replace('%2F')
    });
    return response.ok({
      body: {
        ok: resp.result === 'deleted',
        resp
      }
    });
  } catch (err) {
    logger.error(`deleteAlert: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.deleteAlert = deleteAlert;
function deleteAlertRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.ALERT}/{index}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        index: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, deleteAlert({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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