"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAliases = void 0;
exports.getAliasesRoute = getAliasesRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getAliases = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      alias
    } = request.body;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.cat.aliases({
      alias,
      format: 'json',
      h: 'alias,index'
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`getAliases: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getAliases = getAliases;
function getAliasesRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_aliases`,
    validate: {
      body: _configSchema.schema.object({
        alias: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getAliases({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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