"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndices = void 0;
exports.getIndicesRoute = getIndicesRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getIndices = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      index
    } = request.body;
    const options = {
      ignoreUnavailable: true,
      index,
      body: {
        size: 0,
        // no hits
        aggs: {
          indices: {
            terms: {
              field: '_index',
              size: 800
            }
          }
        }
      }
    };
    const {
      body: {
        aggregations: {
          indices: {
            buckets = []
          } = {}
        } = {}
      } = {}
    } = await clusterClient.asScoped(request).asCurrentUser.search(options);
    return response.ok({
      body: {
        ok: true,
        resp: buckets.map(({
          key
        }) => ({
          index: key,
          health: 'green',
          // TODO: find real health instead
          status: 'open' // TODO: find real status instead
        }))
      }
    });
  } catch (err) {
    logger.error(`getIndices: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getIndices = getIndices;
function getIndicesRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_indices`,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getIndices({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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