"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMappings = void 0;
exports.getMappingsRoute = getMappingsRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getMappings = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      index
    } = request.body;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.indices.getMapping({
      index
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`getMappings: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getMappings = getMappings;
function getMappingsRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_mappings`,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getMappings({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfY29uc3RhbnRzIiwiZ2V0TWFwcGluZ3MiLCJjbHVzdGVyQ2xpZW50IiwibG9nZ2VyIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsImluZGV4IiwiYm9keSIsInJlc3AiLCJhc1Njb3BlZCIsImFzQ3VycmVudFVzZXIiLCJpbmRpY2VzIiwiZ2V0TWFwcGluZyIsIm9rIiwiZXJyIiwiZXJyb3IiLCJzdGFjayIsImN1c3RvbUVycm9yIiwic2VydmVyRXJyb3IiLCJleHBvcnRzIiwiZ2V0TWFwcGluZ3NSb3V0ZSIsInJvdXRlciIsInBvc3QiLCJwYXRoIiwiQkFTRV9VUkkiLCJ2YWxpZGF0ZSIsInNjaGVtYSIsIm9iamVjdCIsIm9uZU9mIiwic3RyaW5nIiwiYXJyYXlPZiJdLCJzb3VyY2VzIjpbImdldF9tYXBwaW5ncy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogICAgQ29weXJpZ2h0IDIwMjAgZmxvcmFndW5uIEdtYkhcbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpO1xuICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuICogWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuICogZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuICogV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gKiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAa2JuL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgc2VydmVyRXJyb3IgfSBmcm9tICcuLi8uLi9saWIvZXJyb3JzJztcbmltcG9ydCB7IEJBU0VfVVJJIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29tbW9uL3NpZ25hbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGNvbnN0IGdldE1hcHBpbmdzID0gKHsgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pID0+IGFzeW5jIChjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSkgPT4ge1xuICB0cnkge1xuICAgIGNvbnN0IHsgaW5kZXggfSA9IHJlcXVlc3QuYm9keTtcblxuICAgIGNvbnN0IHsgYm9keTogcmVzcCB9ID0gYXdhaXQgY2x1c3RlckNsaWVudFxuICAgICAgLmFzU2NvcGVkKHJlcXVlc3QpXG4gICAgICAuYXNDdXJyZW50VXNlci5pbmRpY2VzLmdldE1hcHBpbmcoeyBpbmRleCB9KTtcblxuICAgIHJldHVybiByZXNwb25zZS5vayh7IGJvZHk6IHsgb2s6IHRydWUsIHJlc3AgfSB9KTtcbiAgfSBjYXRjaCAoZXJyKSB7XG4gICAgbG9nZ2VyLmVycm9yKGBnZXRNYXBwaW5nczogJHtlcnIuc3RhY2t9YCk7XG4gICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbUVycm9yKHNlcnZlckVycm9yKGVycikpO1xuICB9XG59O1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0TWFwcGluZ3NSb3V0ZSh7IHJvdXRlciwgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pIHtcbiAgcm91dGVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogYCR7QkFTRV9VUkl9L19tYXBwaW5nc2AsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpbmRleDogc2NoZW1hLm9uZU9mKFtzY2hlbWEuc3RyaW5nKCksIHNjaGVtYS5hcnJheU9mKHNjaGVtYS5zdHJpbmcoKSldKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZ2V0TWFwcGluZ3MoeyBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSlcbiAgKTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQWdCQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxPQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSxVQUFBLEdBQUFGLE9BQUE7QUFsQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQU1PLE1BQU1HLFdBQVcsR0FBR0EsQ0FBQztFQUFFQyxhQUFhO0VBQUVDO0FBQU8sQ0FBQyxLQUFLLE9BQU9DLE9BQU8sRUFBRUMsT0FBTyxFQUFFQyxRQUFRLEtBQUs7RUFDOUYsSUFBSTtJQUNGLE1BQU07TUFBRUM7SUFBTSxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csSUFBSTtJQUU5QixNQUFNO01BQUVBLElBQUksRUFBRUM7SUFBSyxDQUFDLEdBQUcsTUFBTVAsYUFBYSxDQUN2Q1EsUUFBUSxDQUFDTCxPQUFPLENBQUMsQ0FDakJNLGFBQWEsQ0FBQ0MsT0FBTyxDQUFDQyxVQUFVLENBQUM7TUFBRU47SUFBTSxDQUFDLENBQUM7SUFFOUMsT0FBT0QsUUFBUSxDQUFDUSxFQUFFLENBQUM7TUFBRU4sSUFBSSxFQUFFO1FBQUVNLEVBQUUsRUFBRSxJQUFJO1FBQUVMO01BQUs7SUFBRSxDQUFDLENBQUM7RUFDbEQsQ0FBQyxDQUFDLE9BQU9NLEdBQUcsRUFBRTtJQUNaWixNQUFNLENBQUNhLEtBQUssQ0FBQyxnQkFBZ0JELEdBQUcsQ0FBQ0UsS0FBSyxFQUFFLENBQUM7SUFDekMsT0FBT1gsUUFBUSxDQUFDWSxXQUFXLENBQUMsSUFBQUMsbUJBQVcsRUFBQ0osR0FBRyxDQUFDLENBQUM7RUFDL0M7QUFDRixDQUFDO0FBQUNLLE9BQUEsQ0FBQW5CLFdBQUEsR0FBQUEsV0FBQTtBQUVLLFNBQVNvQixnQkFBZ0JBLENBQUM7RUFBRUMsTUFBTTtFQUFFcEIsYUFBYTtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUNsRW1CLE1BQU0sQ0FBQ0MsSUFBSSxDQUNUO0lBQ0VDLElBQUksRUFBRSxHQUFHQyxtQkFBUSxZQUFZO0lBQzdCQyxRQUFRLEVBQUU7TUFDUmxCLElBQUksRUFBRW1CLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNsQnJCLEtBQUssRUFBRW9CLG9CQUFNLENBQUNFLEtBQUssQ0FBQyxDQUFDRixvQkFBTSxDQUFDRyxNQUFNLENBQUMsQ0FBQyxFQUFFSCxvQkFBTSxDQUFDSSxPQUFPLENBQUNKLG9CQUFNLENBQUNHLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztNQUN4RSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0Q3QixXQUFXLENBQUM7SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FDdkMsQ0FBQztBQUNIIiwiaWdub3JlTGlzdCI6W119