"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchEs = void 0;
exports.searchEsRoute = searchEsRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const searchEs = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      body,
      index,
      size
    } = request.body;
    const {
      body: resp
    } = await clusterClient.asScoped(request).asCurrentUser.search({
      index,
      size,
      body
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`searchEs: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.searchEs = searchEs;
function searchEsRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_search`,
    validate: {
      body: _configSchema.schema.object({
        body: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
        size: _configSchema.schema.number({
          defaultValue: _constants.MAX_DOC_COUNT_SEARCH
        })
      }, {
        unknowns: 'allow'
      })
    }
  }, searchEs({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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