"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockElasticsearchError = mockElasticsearchError;
exports.mockElasticsearchErrorResponse = mockElasticsearchErrorResponse;
exports.mockErrorResponse = mockErrorResponse;
exports.mockResponseOkImplementation = mockResponseOkImplementation;
exports.mockSuccessResponse = mockSuccessResponse;
/* eslint-disable @kbn/eslint/require-license-header */
function mockResponseOkImplementation({
  body
}) {
  return {
    status: 200,
    payload: {
      ...body
    },
    options: {
      body
    }
  };
}
function mockSuccessResponse(resp = {}) {
  return {
    status: 200,
    payload: {
      ok: true,
      resp
    },
    options: {
      body: {
        ok: true,
        resp
      }
    }
  };
}
function mockErrorResponse(message, statusCode = 500) {
  return {
    status: 200,
    payload: {
      ok: false,
      resp: {
        message: message,
        statusCode
      }
    },
    options: {
      body: {
        ok: false,
        resp: {
          message: message,
          statusCode
        }
      }
    }
  };
}
const ELASTICSEARCH_ERROR = 'elasticsearch error';
function mockElasticsearchErrorResponse(resp = {}) {
  const mockError = mockErrorResponse(ELASTICSEARCH_ERROR, 400);
  mockError.payload.resp = {
    ...mockError.payload.resp,
    ...resp
  };
  mockError.options.body.resp = {
    ...mockError.options.body.resp,
    ...resp
  };
  return mockError;
}
function mockElasticsearchError(statusCode = 400) {
  return {
    body: {
      status: {},
      watch_id: '123',
      error: {
        message: ELASTICSEARCH_ERROR,
        detail: {}
      }
    },
    statusCode
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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